
/**
 * Skin initialization
 */
function jrSoloPro_init()
{
    $('.index #mute').click(function(){
        var m = document.getElementById('background');
        if (m.muted) {
            $("video").prop('muted', false);
            $('#mute').text('mute')
        }
        else {
            $("video").prop('muted', true);
            $('#mute').text('unmute')
        }
    });

    $('section#profile_menu').sticky({
        topSpacing: 0,
        'classes': {
            'element': 'jquery-sticky-element',
            'start': 'jquery-sticky-start',
            'sticky': 'jquery-sticky-sticky',
            'stopped': 'jquery-sticky-stopped',
            'placeholder': 'jquery-sticky-placeholder'
        }
    });

    $(document).on("click", 'a', function(e)
    {
        var aurl = $(this).attr("href") || "";
        aurl = aurl.replace(" ", "-");
        if (aurl.indexOf("javascript") >= 0 || aurl == "" || aurl.indexOf("#") == 0) {
            e.preventDefault();
            return false;
        }
    });


    $('.profile_image').hover(function()
    {
        $(this).find(".profile_hoverimage").fadeIn();

    }, function()
    {
        $(this).find(".profile_hoverimage").fadeOut();
    });

    var menu = $("ul#horizontal");

    // Get static values here first
    var vw = 0, ctr = menu.children().length;         // number of children will not change
    menu.children().each(function()
    {
        vw += $(this).outerWidth();  // widths will not change, so just a total
    });

    jrSoloPro_collect();  // fire first collection on page load
    $(window).resize(jrSoloPro_collect); // fire collection on window resize

    function jrSoloPro_collect()
    {
        menu.css({
            visibility: 'collapse',
            'width': "calc(100% - 112px)"
        });

        // Calculate fitCount on the total width this time
        var fc = Math.floor((menu.width() / vw) * ctr) - 1;

        // Reset display and width on all list-items
        menu.children().css({"display": "block", "width": "auto"});

        $('ul#horizontal .hideshow').remove();

        // Make a set of collected list-items based on fc
        var cs = menu.children(":gt(" + fc + ")");

        menu.append($('#pm-drop-opt').html());

        // Empty the more menu and add the collected items
        $("#submenu").empty().append(cs.clone());

        // Set display to none and width to 0 on collection,
        // because they are not visible anyway.
        cs.css({"display": "none", "width": "0"});

        if (cs.length > 0) {
            $('ul#horizontal li.hideshow').css('display', 'block').click(function()
            {
                $(this).children("ul").toggle();
            });
        }
        menu.css({
            visibility: 'visible',
            'width': "100%"
        });
    }

    // Scroll To Top Function
    $(window).scroll(function(){
        if ($(this).scrollTop() > 100) {
            $('.scrollup').addClass('show');
        } else {
            $('.scrollup').removeClass('show');
        }
    });

    $('.scrollup').click(function(){
        $("html, body").animate({ scrollTop: 0 }, 1000);
        return false;
    });
}

/**
 * Open a modal window
 * @param id
 * @param profile_url
 */
function jrSoloPro_modal(id, profile_url)
{
    $(id).modal();
    if (profile_url) {
        $('#action_update').text(profile_url + ' ');
    }
}

$(document).ready(function()
{
    jrSoloPro_init();
});

function jrSoloPro_share(site, name, u) {

    var url;
    switch (site) {
        case 'facebook':
            url = 'http://www.facebook.com/sharer.php?u=' + encodeURIComponent(u) + '&amp;t=' + encodeURIComponent(name);
            break;
        case 'twitter':
            url = 'https://twitter.com/intent/tweet?text=' + name + '+' + u;
            break;
        default:
            url = 'https://m.google.com/app/plus/x/?v=compose&content=' + name + '+' + u;
            break;
    }

    window.open(url)
}

