<?php
 /**
 * Jamroom jrSoloPro skin
 *
 * copyright 2023 The Jamroom Network
 *
 * This Jamroom file is LICENSED SOFTWARE, and cannot be redistributed.
 *
 * This Source Code is subject to the terms of the Jamroom Network
 * Commercial License -  please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this skin.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * Jamroom MediaPro Skin
 * @copyright 2003 - 2016 by The Jamroom Network - All Rights Reserved
 */

// We are never called directly
if (!defined('APP_DIR')) {
    exit;
}

/**
 * meta
 */
function jrSoloPro_skin_meta()
{
    $_tmp = array(
        'name'        => 'jrSoloPro',
        'title'       => 'Solo Pro',
        'version'     => '1.1.8',
        'developer'   => 'Talldude Networks, LLC, &copy;' . date('Y'),
        'description' => 'Powerful Social Media features for Musicians and Artists',
        'license'     => 'jcl',
        'category'    => 'music'
    );
    return $_tmp;
}

/**
 * init
 */
function jrSoloPro_skin_init()
{
    global $_conf;

    // Bring in all our CSS files
    jrCore_register_module_feature('jrCore', 'css', 'jrSoloPro', 'acp.css');
    jrCore_register_module_feature('jrCore', 'css', 'jrSoloPro', 'base.css');
    jrCore_register_module_feature('jrCore', 'css', 'jrSoloPro', 'footer.css');
    jrCore_register_module_feature('jrCore', 'css', 'jrSoloPro', 'grid.css');
    jrCore_register_module_feature('jrCore', 'css', 'jrSoloPro', 'header.css');
    jrCore_register_module_feature('jrCore', 'css', 'jrSoloPro', 'html.css');
    jrCore_register_module_feature('jrCore', 'css', 'jrSoloPro', 'image.css');
    jrCore_register_module_feature('jrCore', 'css', 'jrSoloPro', 'core_slidebar.css');
    jrCore_register_module_feature('jrCore', 'css', 'jrSoloPro', 'list.css');
    jrCore_register_module_feature('jrCore', 'css', 'jrSoloPro', 'menu.css');
    jrCore_register_module_feature('jrCore', 'css', 'jrSoloPro', 'profile.css');
    jrCore_register_module_feature('jrCore', 'css', 'jrSoloPro', 'skin.css');
    jrCore_register_module_feature('jrCore', 'css', 'jrSoloPro', 'override_tablet.css');
    jrCore_register_module_feature('jrCore', 'css', 'jrSoloPro', 'override_mobile.css');
    jrCore_register_module_feature('jrCore', 'css', 'jrSoloPro', 'player.css');
    jrCore_register_module_feature('jrCore', 'css', 'jrSoloPro', 'animations.css');
    jrCore_register_module_feature('jrCore', 'css', 'jrSoloPro', 'animations-ie-fix.css');

    if (isset($_conf['jrSoloPro_style']) && $_conf['jrSoloPro_style'] == '1') {
        jrCore_register_module_feature('jrCore', 'css', 'jrSoloPro', 'profile_dark.css');
        jrCore_register_module_feature('jrCore', 'css', 'jrSoloPro', 'skin_dark.css');
    }

    // Register our Javascript files with the core
    jrCore_register_module_feature('jrCore', 'javascript', 'jrSoloPro', 'jquery.sticky.js');
    jrCore_register_module_feature('jrCore', 'javascript', 'jrSoloPro', 'jrSoloPro.js');
    jrCore_register_module_feature('jrCore', 'javascript', 'jrSoloPro', APP_DIR . '/skins/jrSoloPro/contrib/slidebars/slidebars.min.js');

    // Tell the core the default icon set to use (black or white)
    jrCore_register_module_feature('jrCore', 'icon_color', 'jrSoloPro', 'black');

    // Tell the core the size of our action buttons (width in pixels, up to 64)
    jrCore_register_module_feature('jrCore', 'icon_size', 'jrSoloPro', 30);

    jrCore_register_module_feature('jrCore', 'media_player', 'jrSoloPro', 'jrSoloPro_index_video_player', 'video');
    jrCore_register_module_feature('jrCore', 'media_player', 'jrSoloPro', 'jrSoloPro_video_player', 'video');

    // default players
    jrCore_register_module_feature('jrCore', 'media_player_skin', 'jrSoloPro', 'jrVideo', 'jrSoloPro_video_player');
    jrCore_register_module_feature('jrCore', 'media_player_skin', 'jrSoloPro', 'jrAudio', 'jrAudio_blue_monday');
    jrCore_register_module_feature('jrCore', 'media_player_skin', 'jrSoloPro', 'jrPlaylist', 'jrPlaylist_blue_monday');

    // Our default media player skins
    if (isset($_conf['jrSoloPro_style']) && $_conf['jrSoloPro_style'] == '1') {
        jrCore_register_module_feature('jrCore', 'media_player_skin', 'jrSoloPro', 'jrAudio', 'jrAudio_player_dark');
        jrCore_register_module_feature('jrCore', 'media_player_skin', 'jrSoloPro', 'jrPlaylist', 'jrPlaylist_player_dark');
    }

    return true;
}

/**
 * Get action stats
 * @param $params array
 * @param $smarty object
 * @return array|string
 */
function smarty_function_jrSoloPro_stats($params, $smarty)
{
    // Enabled?
    if (!jrCore_module_is_active('jrAction')) {
        return '';
    }

    $out = array();
    if (jrCore_checktype($params['profile_id'], 'number_nz')) {
        $out['actions'] = (int) jrCore_db_run_key_function('jrAction', '_profile_id', $params['profile_id'], 'count');
    }

    // Trigger our action_stats event  (jrFollowers adds in 'following' and 'followers')
    $out = jrCore_trigger_event('jrAction', 'action_stats', $out, $params);

    if (!empty($params['assign'])) {
        $smarty->assign($params['assign'], $out);
        return '';
    }
    return $out;
}

/**
 * verify_skin
 * @return bool
 */
function jrSoloPro_skin_verify()
{
    // lang
    $_ln = jrUser_load_lang_strings(null, false, false); // need to skip caching because skins language strings arent here yet on initial activation.

    $_tmp = array(
        'name'          => 'audio_text',
        'label'         => $_ln['jrSoloPro'][98], // 'Audio Text',
        'help'          => $_ln['jrSoloPro'][99], // 'Enter a description for this audio file',
        'type'          => 'editor',
        'default'       => '',
        'validate'      => 'allowed_html',
        'form_designer' => true,
        'active'        => 1,
        'locked'        => 0
    );
    jrCore_verify_designer_form_field('jrAudio', 'create', $_tmp);
    jrCore_verify_designer_form_field('jrAudio', 'create_album', $_tmp);
    jrCore_verify_designer_form_field('jrAudio', 'update', $_tmp);

    // add the form fields
    $_tmp = array(
        'name'     => 'audio_lyrics',
        'label'         => $_ln['jrSoloPro'][100], // 'Audio Lyrics',
        'help'          => $_ln['jrSoloPro'][101], // 'Enter the lyrics for this audio song',
        'type'     => 'editor',
        'default'  => '',
        'validate' => 'allowed_html',
        'active'   => 1,
        'locked'   => 0
    );
    jrCore_verify_designer_form_field('jrAudio', 'create', $_tmp);
    jrCore_verify_designer_form_field('jrAudio', 'update', $_tmp);


    $_tmp = array(
        'name'          => 'audio_iTunes_url',
        'label'         =>  $_ln['jrSoloPro'][90], // iTunes URL
        'help'          =>  $_ln['jrSoloPro'][91], // Enter the iTunes URL to buy this song
        'type'          => 'text',
        'validate'      => 'url',
        'active'   => 1,
        'locked'   => 0
    );
    jrCore_verify_designer_form_field('jrAudio', 'create', $_tmp);
    jrCore_verify_designer_form_field('jrAudio', 'update', $_tmp);
    jrCore_verify_designer_form_field('jrAudio', 'create_album', $_tmp);

    $_tmp = array(
        'name'          => 'audio_instagram_play_url',
        'label'         => $_ln['jrSoloPro'][92], // instagram Play URL
        'help'          => $_ln['jrSoloPro'][93], // Enter the instagram Play URL to buy this song
        'type'          => 'text',
        'validate'      => 'url',
        'active'   => 1,
        'locked'   => 0
    );
    jrCore_verify_designer_form_field('jrAudio', 'create', $_tmp);
    jrCore_verify_designer_form_field('jrAudio', 'update', $_tmp);
    jrCore_verify_designer_form_field('jrAudio', 'create_album', $_tmp);

    $_tmp = array(
        'name'          => 'audio_cd_baby_url',
        'label'         => $_ln['jrSoloPro'][94], // CD Baby URL
        'help'          =>  $_ln['jrSoloPro'][95], // Enter the CD Baby URL to buy this song
        'type'          => 'text',
        'validate'      => 'url',
        'active'   => 1,
        'locked'   => 0
    );
    jrCore_verify_designer_form_field('jrAudio', 'create', $_tmp);
    jrCore_verify_designer_form_field('jrAudio', 'update', $_tmp);
    jrCore_verify_designer_form_field('jrAudio', 'create_album', $_tmp);

    //////////////////////////////////////////////////////////////////////////////////

    $_tmp = array(
        'name'     => 'video_text',
        'label'         => $_ln['jrSoloPro'][102], // 'Video Text',
        'help'          => $_ln['jrSoloPro'][103], // 'Enter a description of this video',
        'type'     => 'editor',
        'default'  => '',
        'validate' => 'allowed_html',
        'active'   => 1,
        'locked'   => 0
    );
    jrCore_verify_designer_form_field('jrVideo', 'create', $_tmp);
    jrCore_verify_designer_form_field('jrVideo', 'update', $_tmp);

    $_tmp = array(
        'name'     => 'video_category',
        'label'    => $_ln['jrSoloPro'][82], // Video Category
        'help'     => $_ln['jrSoloPro'][83], // Enter a category for this video
        'type'     => 'select_and_text',
        'validate' => 'printable',
        'active'   => 1,
        'locked'   => 0
    );
    jrCore_verify_designer_form_field('jrVideo', 'create', $_tmp);
    jrCore_verify_designer_form_field('jrVideo', 'update', $_tmp);

    ///////////////////////////////////////////////////////////////////////////

    $_tmp = array(
        'name'          => 'profile_header_image',
        'type'          => 'image',
        'label'         => $_ln['jrSoloPro'][84], // Cover Image
        'help'          => $_ln['jrSoloPro'][85], // Enter the home location for this profile
        'active'        => 1,
        'locked'        => 0,
        'image_delete'  => true,
        'form_designer' => true
    );
    jrCore_verify_designer_form_field('jrProfile', 'settings', $_tmp);

    $_tmp = array(
        'name'     => 'profile_website',
        'type'     => 'text',
        'label'         => $_ln['jrSoloPro'][86], // Website
        'sublabel'      => $_ln['jrSoloPro'][87], // must include http://
        'help'          => $_ln['jrSoloPro'][96], // 'Enter the home website for this profile',
        'default'  => '',
        'validate' => 'printable',
        'active'   => 1,
        'locked'   => 0
    );
    jrCore_verify_designer_form_field('jrProfile', 'settings', $_tmp);

    $_tmp = array(
        'name'     => 'profile_location',
        'type'     => 'text',
        'label'         => $_ln['jrSoloPro'][88],
        'sublabel'      => $_ln['jrSoloPro'][89],
        'help'          => $_ln['jrSoloPro'][85], //'Enter the home location for this profile',
        'default'  => '',
        'validate' => 'printable',
        'active'   => 1,
        'locked'   => 0
    );
    jrCore_verify_designer_form_field('jrProfile', 'settings', $_tmp);

    return true;
}

/**
 * skin_deactivate
 * @param $_data
 * @return mixed
 */
function jrSoloPro_skin_deactivate()
{

    jrCore_delete_designer_form_field('jrAudio', 'create', 'audio_text');
    jrCore_delete_designer_form_field('jrAudio', 'create_album', 'audio_text');
    jrCore_delete_designer_form_field('jrAudio', 'update', 'audio_text');
    jrCore_delete_designer_form_field('jrAudio', 'create', 'audio_lyrics');
    jrCore_delete_designer_form_field('jrAudio', 'update', 'audio_lyrics');
    jrCore_delete_designer_form_field('jrAudio', 'create', 'audio_iTunes_url');
    jrCore_delete_designer_form_field('jrAudio', 'update', 'audio_iTunes_url');
    jrCore_delete_designer_form_field('jrAudio', 'create', 'audio_instagram_play_url');
    jrCore_delete_designer_form_field('jrAudio', 'update', 'audio_instagram_play_url');
    jrCore_delete_designer_form_field('jrAudio', 'create', 'audio_cd_baby_url');
    jrCore_delete_designer_form_field('jrAudio', 'update', 'audio_cd_baby_url');

    //////////////////////////////////////////////////////////////////////////////////////////

    jrCore_delete_designer_form_field('jrVideo', 'create', 'video_text');
    jrCore_delete_designer_form_field('jrVideo', 'update', 'video_text');
    jrCore_delete_designer_form_field('jrVideo', 'create', 'video_category');
    jrCore_delete_designer_form_field('jrVideo', 'update', 'video_category');

    //////////////////////////////////////////////////////////////////////////////////////////

    jrCore_delete_designer_form_field('jrProfile', 'settings', 'profile_header_image');
    jrCore_delete_designer_form_field('jrProfile', 'settings', 'profile_website');
    jrCore_delete_designer_form_field('jrProfile', 'settings', 'profile_location');

    return true;
}


/**
 * ShareThis smarty template function
 * @param array $params Smarty function parameters
 * @param array $smarty current Smarty object
 * @return string
 */
function smarty_function_jrSoloPro_shareThis($params, $smarty)
{
    if (!isset($params['module'])) {
        return jrCore_smarty_missing_error('module');
    }
    $_it = array();
    if (isset($params['item_id'])) {
        if (!jrCore_checktype($params['item_id'], 'number_nz')) {
            return jrCore_smarty_invalid_error('item_id');
        }
        $_it = jrCore_db_get_item($params['module'], $params['item_id']);
        if (!$_it) {
            return '';
        }
    }
    $out = jrShareThis_share_feature($params['module'], $_it, $params, $smarty);
    if (!empty($params['assign'])) {
        $smarty->assign($params['assign'], $out);
        return '';
    }
    return $out;
}
