<?php
 /**
 * Jamroom YouTube module
 *
 * copyright 2024 The Jamroom Network
 *
 * This Jamroom file is LICENSED SOFTWARE, and cannot be redistributed.
 *
 * This Source Code is subject to the terms of the Jamroom Network
 * Commercial License -  please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: mass_import_save
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrYouTube_mass_import_save($_post, $_user, $_conf)
{
    jrUser_master_only();
    jrCore_form_validate($_post);
    jrCore_form_modal_notice('update', "importing YouTube videos - please be patient");

    // Check profile ID
    if (!jrCore_checktype($_post['link_profile_id'], 'number_nz')) {
        jrCore_form_delete_session();
        jrCore_form_modal_notice('complete', 'ERROR: Invalid profile ID');
        jrCore_exit();
    }

    // Get profile
    $_pt = jrCore_db_get_item('jrProfile', $_post['link_profile_id']);
    if (!$_pt || !is_array($_pt)) {
        jrCore_form_delete_session();
        jrCore_form_modal_notice('complete', 'ERROR: Profile data not found');
        jrCore_exit();
    }
    $_core = array(
        '_profile_id' => $_pt['_profile_id'],
        '_user_id'    => $_pt['_user_id']
    );

    // Get profile YouTubes
    $_s   = array(
        "search" => array("_profile_id = {$_post['link_profile_id']}"),
        "limit"  => 100000
    );
    $_yt  = jrCore_db_search_items('jrYouTube', $_s);
    $_yts = array();
    if ($_yt['_items'] && is_array($_yt['_items'])) {
        foreach ($_yt['_items'] as $yt) {
            $_yts["{$yt['youtube_id']}"] = true;
        }
    }

    // Get YouTube IDs as an array
    $_ids = explode("\n", $_post['youtube_ids']);
    $ctr  = 0;
    if (is_array($_ids) && count($_ids) > 0) {
        foreach ($_ids as $id) {
            $_ytd = jrYouTube_get_feed_data(trim($id));
            if ($_ytd != '404' && is_array($_ytd)) {
                if ($_yts["{$id}"]) {
                    jrCore_form_modal_notice('update', "'{$_ytd['title']}' exists");
                }
                else {
                    $_tmp = array(
                        'youtube_id'           => $id,
                        'youtube_title'        => $_ytd['title'],
                        'youtube_title_url'    => jrCore_url_string($_ytd['title']),
                        'youtube_category'     => $_ytd['category'],
                        'youtube_category_url' => jrCore_url_string($_ytd['category']),
                        'youtube_description'  => $_ytd['description'],
                        'youtube_artwork_url'  => (isset($_ytd['thumbnail']['hqDefault'])) ? $_ytd['thumbnail']['hqDefault'] : $_ytd['thumbnail']['sqDefault'],
                        'youtube_duration'     => jrCore_format_seconds($_ytd['duration'])
                    );
                    jrCore_db_create_item('jrYouTube', $_tmp, $_core);
                    jrCore_form_modal_notice('update', "'{$_ytd['title']}' imported");
                    $ctr++;
                }
            }
        }
    }

    jrCore_form_delete_session();
    jrCore_form_modal_notice('complete', "{$ctr} YouTube videos imported to specified profile");
    jrCore_exit();
}
