<?php
 /**
 * Jamroom YouTube module
 *
 * copyright 2024 The Jamroom Network
 *
 * This Jamroom file is LICENSED SOFTWARE, and cannot be redistributed.
 *
 * This Source Code is subject to the terms of the Jamroom Network
 * Commercial License -  please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: create_save
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrYouTube_create_save($_post, $_user, $_conf)
{
    // Must be logged in
    jrUser_session_require_login();
    jrCore_form_validate($_post);
    jrUser_check_quota_access('jrYouTube');

    // Get our YouTube ID from the input
    $yid = jrYouTube_extract_id($_post['youtube_id']);
    if (!isset($yid) || !jrCore_checktype($yid, 'url_name')) {
        jrCore_set_form_notice('error', 8);
        jrCore_form_result();
    }
    // See if user has already uploaded this ID
    $_s  = array(
        "search" => array(
            "youtube_id = {$yid}",
            "_profile_id = {$_user['user_active_profile_id']}"
        ),
    );
    $_rt = jrCore_db_search_items('jrYouTube', $_s);
    if (is_array($_rt['_items']) && isset($_rt['_items'][0])) {
        jrCore_set_form_notice('error', 48);
        jrCore_form_result();
    }
    $_ytd = jrYouTube_get_feed_data($yid);
    if (!$_ytd || !is_array($_ytd)) {
        jrCore_set_form_notice('error', 9);
        jrCore_form_result();
    }
    $_tmp = array(
        'youtube_id'           => $yid,
        'youtube_title'        => $_ytd['title'],
        'youtube_title_url'    => jrCore_url_string($_ytd['title']),
        'youtube_category'     => $_ytd['category'],
        'youtube_category_url' => jrCore_url_string($_ytd['category']),
        'youtube_description'  => $_ytd['description'],
        'youtube_artwork_url'  => (isset($_ytd['thumbnail']['hqDefault'])) ? $_ytd['thumbnail']['hqDefault'] : $_ytd['thumbnail']['sqDefault'],
        'youtube_duration'     => jrCore_format_seconds($_ytd['duration'])
    );
    // Add in any custom fields
    $_sv = jrCore_form_get_save_data('jrYouTube', 'create', $_post);
    if (isset($_sv['youtube_id'])) {
        unset($_sv['youtube_id']);
    }
    $_tmp = array_merge($_tmp, $_sv);
    // Create the item
    $yid = jrCore_db_create_item('jrYouTube', $_tmp);
    if (!$yid) {
        jrCore_set_form_notice('error', 47);
        jrCore_form_result();
    }

    // Save any uploaded media files
    jrCore_save_all_media_files('jrYouTube', 'create', $_user['user_active_profile_id'], $yid);

    // Add to Actions...
    jrCore_run_module_function('jrAction_save', 'create', 'jrYouTube', $yid);

    jrCore_form_delete_session();
    jrProfile_reset_cache();
    jrCore_form_result("{$_conf['jrCore_base_url']}/{$_user['profile_url']}/{$_post['module_url']}/{$yid}/{$_tmp['youtube_title_url']}");
}
