<?php
 /**
 * Jamroom Vimeo module
 *
 * copyright 2023 The Jamroom Network
 *
 * This Jamroom file is LICENSED SOFTWARE, and cannot be redistributed.
 *
 * This Source Code is subject to the terms of the Jamroom Network
 * Commercial License -  please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: search
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrVimeo_search($_post, $_user, $_conf)
{
    // Must be logged in to create a new vimeo file
    jrUser_session_require_login();

    // Get language strings
    $_lang = jrUser_load_lang_strings();

    // Start our create form
    jrCore_page_banner(1);

    $ss = $_user['profile_name'];
    if (isset($_post['search_string']) && strlen($_post['search_string']) > 0) {
        $ss = $_post['search_string'];
    }
    $pn = 1;
    if (isset($_post['p']) && jrCore_checktype($_post['p'], 'number_nz')) {
        $pn = $_post['p'];
    }
    $pb = jrCore_get_pager_rows();

    // Search and pagebreak form
    $_tmp = array(
        'submit_value' => 23,
        'cancel'       => "{$_conf['jrCore_base_url']}/{$_user['profile_url']}/{$_post['module_url']}/create"
    );
    jrCore_form_create($_tmp);

    $_tmp = array(
        'name'     => 'search_string',
        'label'    => 1,
        'help'     => 24,
        'type'     => 'text',
        'value'    => $ss,
        'validate' => 'printable',
        'required' => 0
    );
    jrCore_form_field_create($_tmp);

    $_tmp = array(
        'name'  => 'pn',
        'type'  => 'hidden',
        'value' => $pn
    );
    jrCore_form_field_create($_tmp);

    $_vd = jrVimeo_api_request('/videos', array('query' => $ss, 'sort' => 'likes', 'direction' => 'desc', 'page' => $pn, 'per_page' => $pb));

    // Get videos already imported
    $_rt  = array(
        'search'         => array(
            "_profile_id = {$_user['user_active_profile_id']}"
        ),
        'return_keys'    => array('vimeo_id'),
        'privacy_check'  => false,
        'ignore_pending' => true,
        'limit'          => 1000
    );
    $_rt  = jrCore_db_search_items('jrVimeo', $_rt);
    $_ids = array();
    if ($_rt && is_array($_rt) && isset($_rt['_items'])) {
        foreach ($_rt['_items'] as $_itm) {
            $_ids["{$_itm['vimeo_id']}"] = 1;
        }
    }

    // Show results
    if (!empty($_vd['data']) && is_array($_vd['data'])) {

        $dat[0]['title'] = "";
        $dat[0]['width'] = '2%';
        $dat[1]['title'] = $_lang['jrVimeo'][29];
        $dat[1]['width'] = '18%';
        $dat[2]['title'] = $_lang['jrVimeo'][30];
        $dat[2]['width'] = '35%';
        $dat[3]['title'] = $_lang['jrVimeo'][31];
        $dat[3]['width'] = '41%';
        $dat[4]['title'] = $_lang['jrVimeo'][32];
        if (jrCore_module_is_active('jrTags') && jrUser_check_quota_access('jrTags')) {
            $dat[4]['width'] = '2%';
            $dat[5]['title'] = $_lang['jrVimeo'][46];
            $dat[5]['width'] = '2%';
        }
        else {
            $dat[4]['width'] = '4%';
        }
        jrCore_page_table_header($dat);

        $i = ($pb * ($pn - 1)) + 1;
        foreach ($_vd['data'] as $_vid) {

            $id = substr($_vid['uri'], strrpos($_vid['uri'], '/') + 1);

            $dat[0]['title'] = $i;
            $dat[0]['class'] = 'center';

            // Get image URL
            $src = '';
            if (!empty($_vid['pictures']['sizes']) && is_array($_vid['pictures']['sizes'])) {
                $src = $_vid['pictures']['sizes'][2]['link_with_play_button'];
            }

            $dat[1]['title'] = '<img src="' . $src . '" width="200" height="150" style="cursor:pointer" alt="' . jrCore_entity_string($_vid['name']) . '" onclick="jrVimeo_load_video(\'' . $id . '\');">';
            $dat[1]['class'] = 'center" id="v' . $id . '" style="position:relative';

            $tags = '';
            if (jrCore_module_is_active('jrTags') && jrUser_check_quota_access('jrTags')) {
                if (isset($_vid['tags']) && is_array($_vid['tags'])) {
                    $tags = array();
                    foreach ($_vid['tags'] as $_t) {
                        $tags[] = trim($_t['tag']);
                    }
                    $tags = implode(', ', $tags);
                }
            }
            $dat[2]['title'] = "<strong>{$_lang['jrVimeo'][13]}:</strong> <a href=\"//vimeo.com/{$id}\" target=\"_blank\">{$_vid['name']}</a><br><br><strong>{$_lang['jrVimeo'][35]}:</strong> " . jrCore_format_seconds($_vid['duration']) . "<br><br><strong>{$_lang['jrVimeo'][47]}:</strong> <small>{$tags}</small>";

            if (mb_strlen($_vid['description']) > 400) {
                $_vid['description'] = mb_substr($_vid['description'], 0, 400) . '...';
            }
            $dat[3]['title'] = $_vid['description'];

            if (!isset($_ids[$id])) {
                $dat[4]['title'] = '<input type="checkbox" name="import_video_' . $id . '">';
                $dat[4]['class'] = 'center';
                if (strlen($tags) > 0) {
                    $dat[5]['title'] = '<input type="checkbox" name="import_tags_' . $id . '">';
                    $dat[5]['class'] = 'center';
                }
            }
            else {
                $dat[4]['title'] = '&#10003;';
                $dat[4]['class'] = 'center';
                if (jrCore_module_is_active('jrTags') && jrUser_check_quota_access('jrTags')) {
                    $dat[5]['title'] = '&nbsp;';
                }
            }
            jrCore_page_table_row($dat);
            $i++;
        }
        unset($dat);
        $dat[0]['title'] = "<a onclick=\"$('.page_table').find(':checkbox').attr('checked', 'checked');\">" . $_lang['jrVimeo'][37] . '</a>';
        $dat[0]['class'] = 'p10 right';
        $dat[0]['style'] = '" colspan="5';
        jrCore_page_table_row($dat);

        $tpg = ceil($_vd['total'] / $pb);
        $_pg = array(
            'info' => array(
                'total_pages' => ($tpg > 100) ? 100 : $tpg,
                'prev_page'   => ($pn > 1) ? ($pn - 1) : 0,
                'this_page'   => ($pn > 0) ? $pn : 1,
                'next_page'   => ($pn > 0) ? ($pn + 1) : 0
            )
        );
        jrCore_page_table_pager($_pg);
        jrCore_page_table_footer();
    }
    else {
        jrCore_page_notice('notice', $_lang['jrVimeo'][33]);
    }
    jrCore_page_display();
}
