<?php
 /**
 * Jamroom Vimeo module
 *
 * copyright 2023 The Jamroom Network
 *
 * This Jamroom file is LICENSED SOFTWARE, and cannot be redistributed.
 *
 * This Source Code is subject to the terms of the Jamroom Network
 * Commercial License -  please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: display_player
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrVimeo_display_player($_post, $_user, $_conf)
{
    if (!jrCore_checktype($_post['_1'], 'number_nz')) {
        return 'invalid vimeo_id';
    }
    $_rt = jrCore_db_get_item('jrVimeo', $_post['_1']);
    if (!$_rt || !is_array($_rt)) {
        return 'invalid vimeo_id (2)';
    }
    $player = '';
    if (jrCore_checktype($_rt['vimeo_id'], 'number_nz')) {
        if (!isset($_post['_4'])) {
            $_post['_4'] = '300';
        }
        if (!isset($_post['_3'])) {
            $_post['_3'] = '400';
        }
        if ($_post['_2'] && $_post['_2'] != 'false') {
            $_post['_2'] = 1;
        }
        else {
            $_post['_2'] = 0;
        }
        $player = jrVimeo_get_player($_rt['vimeo_id'], $_post['_2'], $_post['_3'], $_post['_4']);
        if ($player && strlen($player) > 0) {
            // Increment stream counter
            jrCore_counter('jrVimeo', $_post['_1'], 'vimeo_stream');
        }
    }
    return $player;
}
