<?php
 /**
 * Jamroom Vimeo module
 *
 * copyright 2023 The Jamroom Network
 *
 * This Jamroom file is LICENSED SOFTWARE, and cannot be redistributed.
 *
 * This Source Code is subject to the terms of the Jamroom Network
 * Commercial License -  please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: create
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrVimeo_create($_post, $_user, $_conf)
{
    // Must be logged in to create a new vimeo file
    jrUser_session_require_login();

    // Get language strings
    $_lang = jrUser_load_lang_strings();

    if (strlen($_conf['jrVimeo_consumer_key']) == 0 || strlen($_conf['jrVimeo_consumer_secret']) == 0) {
        jrCore_logger('CRI', 'Vimeo is not configured correctly - verify settings in Global Config');
        if (jrUser_is_admin()) {
            jrCore_notice_page('error', 'Vimeo is not configured correctly - verify settings in Global Config');
        }
        jrCore_notice_page('notice', 'Vimeo support is currently down - please try again later');
    }

    // Start our create form
    $_sr = array(
        "_profile_id = {$_user['user_active_profile_id']}",
    );
    $tmp = jrCore_page_banner_item_jumper('jrVimeo', 'vimeo_title', $_sr, 'create', 'update');
    jrCore_page_banner($_lang['jrVimeo'][2], $tmp);

    // Form init
    $_tmp = array(
        'submit_value' => 2,
        'cancel'       => jrCore_is_profile_referrer()
    );
    jrCore_form_create($_tmp);

    jrCore_page_note('<div class="p5">' . $_lang['jrVimeo'][42] . '&nbsp' . jrCore_page_button('as', $_lang['jrVimeo'][1], "jrCore_window_location('{$_conf['jrCore_base_url']}/{$_post['module_url']}/search')") . '</div>');

    // Vimeo ID
    $_tmp = array(
        'name'     => 'vimeo_id',
        'label'    => 4,
        'help'     => 5,
        'type'     => 'text',
        'validate' => 'printable',
        'required' => true
    );
    jrCore_form_field_create($_tmp);

    // Tags option
    if (jrCore_module_is_active('jrTags') && jrUser_check_quota_access('jrTags')) {
        $_tmp = array(
            'name'          => 'vimeo_tags',
            'label'         => 48,
            'help'          => 49,
            'default'       => 'off',
            'type'          => 'checkbox',
            'validate'      => 'onoff',
            'required'      => true,
            'form_designer' => false
        );
        jrCore_form_field_create($_tmp);
    }
    jrCore_page_display();
}
