<?php
/**
 * Jamroom Video Module - m4v Video File Support plugin
 * Copyright 2003 - 2012 by the Jamroom Network - all rights reserved
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * Decode an input file
 * @param string $input_file
 * @param array $_options
 * @param string $error_file
 * @return mixed
 */
function jrVideo_m4v_decode($input_file, $_options, $error_file)
{
    return $input_file;
}

/**
 * Encode a new video file
 * @param string $input_file
 * @param array $_options
 * @param string $error_file
 * @return string
 */
function jrVideo_m4v_encode($input_file, $_options, $error_file)
{
    global $_conf;
    $ffmpeg = jrVideo_get_ffmpeg_command();

    $preset = 'veryfast';
    if (isset($_conf['jrVideo_x264_preset']) && strlen($_conf['jrVideo_x264_preset']) > 0) {
        $preset = trim($_conf['jrVideo_x264_preset']);
    }

    // Audio codec
    ob_start();
    system("{$ffmpeg} -encoders 2>/dev/null | grep aac");
    $tmp = ob_get_clean();
    if (!empty($tmp) && strpos($tmp, 'libfaac')) {
        $acodec = 'libfaac';
    }
    else {
        $acodec = 'aac';
    }

    // M4V version
    ob_start();
    jrCore_run_module_function('jrCloudClient_start_timer', 'jrVideo', 'convert');
    system("{$ffmpeg} -y -i \"{$input_file}\" -threads " . jrVideo_get_ffmpeg_thread() . " -acodec {$acodec} -vcodec libx264 -movflags +faststart -preset {$preset} \"{$input_file}.m4v\" >/dev/null 2>{$error_file}", $ret);
    jrCore_run_module_function('jrCloudClient_stop_timer', 'jrVideo', 'convert');
    ob_end_clean();

    return "{$input_file}.m4v";
}
