<?php
/**
 * Jamroom Video Module - flv Video File Support plugin
 * Copyright 2003 - 2012 by the Jamroom Network - all rights reserved
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * Decode an input file
 * @param string $input_file
 * @param array $_options
 * @param string $error_file
 * @return mixed
 */
function jrVideo_flv_decode($input_file, $_options, $error_file)
{
    return $input_file;
}

/**
 * Encode a new video file
 * @param string $input_file
 * @param array $_options
 * @param string $error_file
 * @return string
 */
function jrVideo_flv_encode($input_file, $_options, $error_file)
{
    $ffmpeg = jrVideo_get_ffmpeg_command();

    // FLV Copy for legacy browsers
    ob_start();
    $ext = jrCore_file_extension($input_file);
    $m4v = str_replace(".{$ext}", '.m4v', $input_file);
    jrCore_run_module_function('jrCloudClient_start_timer', 'jrVideo', 'convert');
    system("{$ffmpeg} -i \"{$m4v}\" -vcodec copy -acodec libmp3lame -ar 44100 -ab 128k \"{$input_file}.flv\" >/dev/null 2>{$error_file}", $ret);
    jrCore_run_module_function('jrCloudClient_stop_timer', 'jrVideo', 'convert');
    ob_end_clean();

    return "{$input_file}.flv";
}
