<?php
 /**
 * Jamroom Users module
 *
 * copyright 2025 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: whois
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrUser_whois($_post, $_user, $_conf)
{
    jrUser_admin_only();
    jrCore_page_set_meta_header_only();

    $button = jrCore_page_button('close', 'close', 'self.close();');
    if (!isset($_post['_1']) || !jrCore_checktype($_post['_1'], 'ip_address')) {
        jrCore_page_banner('whois lookup', $button);
        jrCore_notice_page('error', 'Invalid IP Address');
    }

    jrCore_page_banner("whois lookup: {$_post['_1']}", $button);
    $_rt = jrUser_whois_lookup($_post['_1']);
    if (!$_rt || !is_array($_rt)) {
        jrCore_notice_page('error', 'Unable to run whois for IP Address');
    }

    // Do we have a session using this IP right now?
    if ($_us = jrUser_session_online_user_info()) {
        $header = false;
        foreach ($_us as $u) {
            if ($u['session_user_ip'] == $_post['_1']) {
                if (!$header) {
                    $dat             = array();
                    $dat[1]['title'] = 'User';
                    $dat[1]['width'] = '20%';
                    $dat[2]['title'] = 'Action';
                    $dat[2]['width'] = '80%';
                    jrCore_page_table_header($dat);
                    $header = true;
                }
                $dat             = array();
                $dat[1]['title'] = (!empty($u['session_user_name'])) ? $u['session_user_name'] : 'visitor';
                $dat[1]['class'] = 'center';
                $dat[2]['title'] = $u['session_user_action'];
                jrCore_page_table_row($dat);
            }
        }
    }


    // Is the Geo Module installed and working?
    if (jrCore_module_is_active('jrGeo')) {
        $_ip = jrGeo_location($_post['_1']);
        if ($_ip && is_array($_ip) && isset($_ip['latitude'])) {

            $dat             = array();
            $dat[1]['title'] = 'Geo Key';
            $dat[1]['width'] = '20%';
            $dat[2]['title'] = 'Geo Value';
            $dat[2]['width'] = '80%';
            jrCore_page_table_header($dat);

            foreach ($_ip as $k => $v) {
                if (strlen(trim($v)) > 0) {
                    $dat             = array();
                    $dat[1]['title'] = $k;
                    $dat[1]['class'] = 'center';
                    $dat[2]['title'] = $v;
                    jrCore_page_table_row($dat);
                }
            }
        }
    }

    if (count($_rt) > 0) {
        $dat             = array();
        $dat[1]['title'] = 'Whois Key';
        $dat[1]['width'] = '20%';
        $dat[2]['title'] = 'Whois Value';
        $dat[2]['width'] = '80%';
        jrCore_page_table_header($dat, null, true);

        foreach ($_rt as $k => $v) {
            $dat             = array();
            $dat[1]['title'] = $k;
            $dat[1]['class'] = 'center';
            $dat[2]['title'] = $v;
            jrCore_page_table_row($dat);
        }
    }

    $dat             = array();
    $dat[1]['title'] = jrCore_page_button('close', 'close', 'self.close()');
    $dat[1]['class'] = 'p10 center';
    jrCore_page_table_row($dat);

    jrCore_page_table_footer();
    jrCore_page_display();
}
