<?php
 /**
 * Jamroom Users module
 *
 * copyright 2025 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: signup_save
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrUser_signup_save($_post, $_user, $_conf)
{
    // @note: DO NOT use jrCore_form_validate here if we are using TEMPLATES
    // we have to handle validation on our own due to caching
    $tpls = false;
    if (jrCore_get_config_value('jrUser', 'use_templates', 'off') == 'off') {
        jrCore_form_validate($_post);
    }
    else {
        $tpls = true;
        $pass = false;
        foreach ($_post as $k => $v) {
            if (strpos($k, 'user_is_human') === 0 && $v == 'on') {
                // We're good - if the User Is Human checkbox is NOT checked it does not show up in $_post
                $pass = true;
                break;
            }
        }
        if (!$pass) {
            jrCore_set_form_notice('error', 92);
            jrCore_form_result();
        }
        // We have to account for FORM DESIGNER custom fields
        if ($_fields = jrCore_get_designer_form_fields('jrUser', 'signup')) {
            if (is_array($_fields)) {
                foreach ($_fields as $f) {
                    if (is_string($f) && isset($_post[$f])) {
                        $_post = jrCore_form_validate_posted_field('jrUser', $f, $_post);
                    }
                }
            }
        }
    }

    // Make sure we get a good user_name
    $_post['user_name'] = ltrim(trim($_post['user_name'], '@'));
    if (empty($_post['user_name']) || !jrCore_checktype($_post['user_name'], 'valid_name')) {
        jrCore_set_form_notice('error', 129);
        jrCore_form_field_hilight('user_name');
        jrCore_form_result();
    }

    // Make sure it is a UNIQUE name
    if (!jrCore_checktype($_post['user_name'], 'unique_name')) {
        jrCore_set_form_notice('error', 33);
        jrCore_form_field_hilight('user_name');
        jrCore_form_result();
    }

    // Make sure we get a good email
    $_post['user_email'] = trim($_post['user_email']);
    if (empty($_post['user_email']) || !jrCore_checktype($_post['user_email'], 'email')) {
        jrCore_set_form_notice('error', 68);
        jrCore_form_field_hilight('user_email');
        jrCore_form_result();
    }

    // Make sure user_name is not a banned word...
    if (jrCore_run_module_function('jrBanned_is_banned', 'name', $_post['user_name'])) {
        jrCore_set_form_notice('error', 55);
        jrCore_form_field_hilight('user_name');
        jrCore_form_result();
    }

    // Make sure user_name is not a banned email...
    if (jrCore_run_module_function('jrBanned_is_banned', 'email', $_post['user_email'])) {
        jrCore_set_form_notice('error', 96);
        jrCore_form_field_hilight('user_email');
        jrCore_form_result();
    }

    // Verify our passwords match
    if (!isset($_post['user_passwd1']) || strlen("{$_post['user_passwd1']}") === 0 || !isset($_post['user_passwd2']) || strlen("{$_post['user_passwd2']}") === 0) {
        jrCore_set_form_notice('error', 35);
        jrCore_form_field_hilight('user_passwd1');
        jrCore_form_field_hilight('user_passwd2');
        jrCore_form_result();
    }
    if ($_post['user_passwd1'] != $_post['user_passwd2']) {
        jrCore_set_form_notice('error', 35);
        jrCore_form_field_hilight('user_passwd1');
        jrCore_form_field_hilight('user_passwd2');
        jrCore_form_result();
    }

    // Max password length is 80 chars
    if (strlen($_post['user_passwd1']) > 80) {
        jrCore_set_form_notice('error', 136);
        jrCore_form_field_hilight('user_passwd1');
        jrCore_form_field_hilight('user_passwd2');
        jrCore_form_result();
    }

    // Make sure the quota they are signing up for is allowed
    if (!isset($_post['quota_id']) || !jrCore_checktype($_post['quota_id'], 'number_nz')) {
        jrCore_set_form_notice('error', 61);
        jrCore_form_result();
    }
    $_qt = jrProfile_get_quota($_post['quota_id']);
    if (!isset($_qt['quota_jrUser_allow_signups']) || $_qt['quota_jrUser_allow_signups'] != 'on') {
        jrCore_set_form_notice('error', 61);
        jrCore_form_result();
    }

    // Make sure they don't already exist (user_email)
    $_rt = jrCore_db_get_item_by_key('jrUser', 'user_email', $_post['user_email']);
    if (is_array($_rt)) {
        jrCore_set_form_notice('error', 34);
        jrCore_form_field_hilight('user_email');
        jrCore_form_result();
    }

    // Our data from our signup form
    $_data = jrCore_form_get_save_data('jrUser', 'signup', $_post);

    // Setup our default user values
    $pass = jrUser_get_password_hash($_post['user_passwd1']);
    $code = md5(microtime() . mt_rand());

    // Some fields we don't save
    unset($_data['user_passwd1'], $_data['user_passwd2']);

    // Create our user account
    $_data['user_name']       = $_post['user_name'];
    $_data['user_email']      = $_post['user_email'];
    $_data['user_password']   = $pass;
    $_data['user_language']   = (!empty($_post['user_language'])) ? $_post['user_language'] : $_conf['jrUser_default_language'];
    $_data['user_active']     = 0;
    $_data['user_validated']  = 0;
    $_data['user_validate']   = $code;
    $_data['user_last_login'] = 0;

    // Trigger now that we have passed
    $_data = jrCore_trigger_event('jrUser', 'signup_validate', $_data);

    $uid = jrCore_db_create_item('jrUser', $_data);
    if (!$uid || !jrCore_checktype($uid, 'number_nz')) {
        jrCore_set_form_notice('error', 36);
        jrCore_form_result();
    }
    // Update our _user_id value
    // If this is the FIRST USER on the system, they are master
    $first = false;
    $_temp = array('user_group' => 'user');
    $_core = array('_user_id' => $uid);
    if ($uid < 10) {
        $cnt = jrCore_db_get_datastore_item_count('jrUser');
        if ($cnt < 2) {
            // For our first user account, we automatically activate their account and make them a master
            $_temp = array(
                'user_group' => 'master'
            );
            // Let's also update the CORE with their email address
            jrCore_set_setting_value('jrMailer', 'from_email', $_post['user_email']);
            jrCore_delete_all_cache_entries('jrCore', 0);
            $first = true;
        }
    }
    jrCore_db_update_item('jrUser', $uid, $_temp, $_core);

    // If this user is signing up, and was previously suppressed, un-suppress
    $tbl = jrCore_db_table_name('jrUser', 'suppressed');
    $req = "DELETE FROM {$tbl} WHERE email_address = '" . jrCore_db_escape($_post['user_email']) . "'";
    jrCore_db_query($req);

    // User account is created - send out trigger so any listening
    // modules can do their work for this new user
    $_data['_user_id'] = $uid;
    $_post             = jrCore_trigger_event('jrUser', 'signup_created', $_post, $_data);

    // Save new user stats
    jrCore_create_stat_entry('jrUser', 'new_users', 'daily', 0, 0, null, false);

    if ($first) {

        // Our first account is our MASTER ADMIN account - validate instantly
        jrCore_form_result("{$_conf['jrCore_base_url']}/{$_post['module_url']}/activate/{$code}");

    }
    else {

        // If a listener has changed user_active = 1, then switch to INSTANT
        if (isset($_data['user_active']) && jrCore_checktype($_data['user_active'], 'is_true')) {
            $_qt['quota_jrUser_signup_method'] = 'instant';
        }

        // See what type of signup method are are doing
        switch ($_qt['quota_jrUser_signup_method']) {

            case 'instant':

                // Instant Account validation
                jrCore_form_delete_session();
                $add = '';
                if (isset($_post['r']) && strlen($_post['r']) > 0) {
                    $add = '/r=1';
                    if ($_post['r'] != '1') {
                        if (jrCore_get_memory_url($_post['r'])) {
                            $add = "/r={$_post['r']}";
                        }
                    }
                }
                jrCore_form_result("{$_conf['jrCore_base_url']}/{$_post['module_url']}/activate/{$code}{$add}");
                break;

            case 'admin':

                // Admin validation
                if (isset($_conf['jrUser_signup_notify']) && $_conf['jrUser_signup_notify'] == 'on') {
                    $_ad = jrUser_get_admin_user_ids();
                    if ($_ad && is_array($_ad)) {
                        $_rp                    = $_data;
                        $_rp['signup_method']   = 'admin';
                        $_rp['system_name']     = $_conf['jrCore_system_name'];
                        $_rp['ip_address']      = jrCore_get_ip();
                        $_rp['new_profile_url'] = "{$_conf['jrCore_base_url']}/" . jrCore_url_string($_post['user_name']);
                        list($sub, $msg) = jrCore_parse_email_templates('jrUser', 'notify_signup', $_rp);
                        jrUser_notify($_ad, 0, 'jrUser', 'signup_notify', $sub, $msg);
                    }
                }
                $_ln = jrUser_load_lang_strings();
                jrCore_form_delete_session();
                if ($tpls) {
                    jrCore_set_form_notice('success', $_ln['jrUser'][105], false);
                    jrCore_form_result();
                }
                jrCore_notice_page('success', "<p>{$_ln['jrUser'][105]}</p>", $_conf['jrCore_base_url'], $_ln['jrCore'][87], false);
                break;

            default:

                $add = '';
                if (isset($_post['r']) && strlen($_post['r']) > 0) {
                    if (jrCore_get_memory_url($_post['r'])) {
                        $add = "/r={$_post['r']}";
                    }
                }
                $url = "{$_conf['jrCore_base_url']}/{$_post['module_url']}/activate/{$code}{$add}";
                // Send User Account validation email - Admins are sent a notification
                // email AFTER the user has validated their account
                $_rp = array(
                    'system_name'    => $_conf['jrCore_system_name'],
                    'activation_url' => $url
                );
                list($sub, $msg) = jrCore_parse_email_templates('jrUser', 'signup', $_rp);
                jrCore_send_email($_post['user_email'], $sub, $msg);

                // Our User Account is created...
                jrCore_logger('INF', "user: {$_post['user_email']} has signed up and is pending validation");
                jrCore_form_delete_session();

                if (!empty($_conf['jrUser_use_templates']) && $_conf['jrUser_use_templates'] == 'on') {
                    jrCore_set_form_notice('success', 37);
                    jrCore_form_result();
                }
                else {
                    $_ln = jrUser_load_lang_strings();
                    jrCore_notice_page('success', "<p>{$_ln['jrUser'][37]}</p>", $_conf['jrCore_base_url'], $_ln['jrCore'][87], false);
                }
                break;
        }

    }
    return true;
}
