<?php
 /**
 * Jamroom Users module
 *
 * copyright 2025 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: new_password_save
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrUser_new_password_save($_post, $_user, $_conf)
{
    jrCore_form_validate($_post);

    // Make sure our token is valid
    if (!isset($_post['password_token']) || !jrCore_checktype($_post['password_token'], 'md5')) {
        jrCore_set_form_notice('error', 52);
        jrCore_form_result();
    }

    // Validate Token
    $tkn = jrCore_db_escape($_post['password_token']);
    $tbl = jrCore_db_table_name('jrUser', 'forgot');
    $req = "SELECT * FROM {$tbl} WHERE forgot_key = '{$tkn}' LIMIT 1";
    $_rt = jrCore_db_query($req, 'SINGLE');
    if (!$_rt || !is_array($_rt)) {
        jrCore_set_form_notice('error', 52);
        jrCore_form_result();
    }

    // Get user info
    $_us = jrCore_db_get_item('jrUser', $_rt['forgot_user_id'], true);
    if (!$_us || !is_array($_us)) {
        jrCore_set_form_notice('error', 52);
        jrCore_form_result();
    }

    // Make sure account is not blocked
    if (isset($_rt['user_blocked']) && $_rt['user_blocked'] == 1) {
        jrCore_set_form_notice('error', 49);
        jrCore_form_result();
    }

    // Make sure account is active and not blocked
    if (!isset($_us['user_active']) || $_us['user_active'] != 1) {
        jrCore_set_form_notice('error', 29);
        jrCore_form_result();
    }

    // Make sure passwords match
    if (!isset($_post['user_passwd1']) || strlen("{$_post['user_passwd1']}") === 0 || !isset($_post['user_passwd2']) || strlen("{$_post['user_passwd2']}") === 0) {
        jrCore_set_form_notice('error', 35);
        jrCore_form_field_hilight('user_passwd1');
        jrCore_form_field_hilight('user_passwd2');
        jrCore_form_result();
    }
    if ($_post['user_passwd1'] != $_post['user_passwd2']) {
        jrCore_set_form_notice('error', 35);
        jrCore_form_field_hilight('user_passwd1');
        jrCore_form_field_hilight('user_passwd2');
        jrCore_form_result();
    }
    // Setup new password
    $pass = jrUser_get_password_hash($_post['user_passwd1']);

    // Update user with new password
    $_dt = array(
        'user_password'   => $pass,
        'user_last_login' => 'UNIX_TIMESTAMP()'
    );
    if (!jrCore_db_update_item('jrUser', $_rt['forgot_user_id'], $_dt)) {
        jrCore_set_form_notice('error', 36);
        jrCore_form_result();
    }
    // has user been validated yet
    if (!isset($_us['user_validated']) || $_us['user_validated'] != '1') {
        jrCore_set_form_notice('error', 27);
        jrCore_form_result();
    }

    // Remove all existing sessions
    jrUser_session_remove($_us['_user_id']);

    // Remove any "remember me" cookie
    $tbl = jrCore_db_table_name('jrUser', 'cookie');
    $req = "DELETE FROM {$tbl} WHERE cookie_user_id = '{$_us['_user_id']}'";
    jrCore_db_query($req);

    // Reset user cache
    jrUser_reset_cache($_us['_user_id']);

    // Cleanup forgot
    jrUser_delete_forgot_password_entries($_us['_user_id']);

    // User has logged in - reset any failed password attempts on this IP
    jrUser_reset_password_attempts(jrCore_get_ip());

    // Log user in if we are NOT in maintenance mode
    if (isset($_conf['jrCore_maintenance_mode']) && $_conf['jrCore_maintenance_mode'] == 'on') {
        // If we are NOT an admin...
        if ($_us['user_group'] != 'master' && $_us['user_group'] != 'admin') {
            jrCore_notice_page('error', 30);
        }
    }

    // Startup session with user info
    $_SESSION = jrUser_get_user_session_data($_us['_user_id']);
    $_SESSION = jrCore_trigger_event('jrUser', 'login_success', $_SESSION);

    // Set NEW remember me cookie if enabled
    if (jrUser_get_auto_login_expiration_days() > 1) {
        jrUser_session_set_login_cookie($_us['_user_id']);
    }

    // See if this user is logging in for the first time on a new device
    if (isset($_SESSION['quota_jrUser_device_notice']) && $_SESSION['quota_jrUser_device_notice'] == 'on') {
        jrUser_notify_if_new_device($_us['_user_id']);
    }

    // Show them success
    jrCore_logger('INF', "user: user_id {$_SESSION['_user_id']} - {$_SESSION['user_email']} - has reset their password and logged in");

    // Redirect to Profile
    if (!empty($_SESSION['profile_url'])) {
        jrCore_form_result("{$_conf['jrCore_base_url']}/{$_SESSION['profile_url']}");
    }
    // Fall through - system index
    jrCore_form_result($_conf['jrCore_base_url']);
}
