<?php
 /**
 * Jamroom Users module
 *
 * copyright 2025 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: import_language_options
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrUser_import_language_options($_post, $_user, $_conf)
{
    global $_mods;
    jrUser_master_only();
    if (!isset($_post['_1']) || strlen($_post['_1']) === 0) {
        jrCore_set_form_notice('error', "invalid unique file id - unable to import");
        jrCore_location("{$_conf['jrCore_base_url']}/{$_post['module_url']}/import_language");
    }

    // Get file
    $dir = jrCore_get_module_cache_dir('jrUser');
    $fil = "{$dir}/{$_post['_1']}.lang";
    if (!is_file($fil)) {
        jrCore_set_form_notice('error', "language file not found - unable to import");
        jrCore_location("{$_conf['jrCore_base_url']}/{$_post['module_url']}/import_language");
    }

    $_tm = explode("\n", file_get_contents($fil));
    if (!$_tm || !is_array($_tm)) {
        jrCore_set_form_notice('error', "invalid language file - unable to import");
        jrCore_location("{$_conf['jrCore_base_url']}/{$_post['module_url']}/import_language");
    }

    jrCore_page_include_admin_menu();
    jrCore_page_admin_tabs('jrUser');

    $button = jrCore_page_button('uncheck', 'unselect all', "$('#jrUser_import_language_options').find('.form_checkbox').prop('checked', false)");
    jrCore_page_banner('import language options', $button);
    jrCore_get_form_notice();

    // Form init
    $_tmp = array(
        'submit_value'     => 'import selected options',
        'cancel'           => "{$_conf['jrCore_base_url']}/{$_post['module_url']}/import_language",
        'form_ajax_submit' => false
    );
    jrCore_form_create($_tmp);

    // Go through file and get installed modules
    $_sks = jrCore_get_skins();
    $_mds = array();
    $_skn = array();
    foreach ($_tm as $line) {
        $mod = substr($line, 0, strpos($line, ':'));
        if (isset($_mods[$mod]) && !isset($_mds[$mod])) {
            $_mds[$mod] = $_mods[$mod]['module_name'];
        }
        elseif (isset($_sks[$mod]) && !isset($_skn[$mod])) {
            $_tmp       = jrCore_skin_meta_data($mod);
            $_skn[$mod] = $_tmp['name'];
        }
    }

    $_tmp = array(
        'name'  => 'import_id',
        'type'  => 'hidden',
        'value' => $_post['_1']
    );
    jrCore_form_field_create($_tmp);

    // Module Options
    natcasesort($_mds);
    $_tmp = array(
        'name'     => 'import_modules',
        'label'    => 'Selected for Import',
        'help'     => 'Select the modules you would like to import language strings for',
        'type'     => 'optionlist',
        'options'  => $_mds,
        'default'  => implode(',', array_keys($_mds)),
        'layout'   => 'columns',
        'columns'  => 3,
        'required' => true,
        'section'  => 'module language strings'
    );
    jrCore_form_field_create($_tmp);

    // Skins
    if (count($_skn) > 0) {
        natcasesort($_skn);
        $_tmp = array(
            'name'     => 'import_skins',
            'label'    => 'Selected for Import',
            'help'     => 'Select the skins you would like to import language strings for',
            'type'     => 'optionlist',
            'options'  => $_skn,
            'default'  => implode(',', array_keys($_skn)),
            'layout'   => 'columns',
            'columns'  => 3,
            'required' => true,
            'section'  => 'skin language strings'
        );
        jrCore_form_field_create($_tmp);
    }
    jrCore_page_display();

}
