<?php
 /**
 * Jamroom Users module
 *
 * copyright 2025 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: forgot_save
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrUser_forgot_save($_post, $_user, $_conf)
{
    jrCore_form_validate($_post);

    $_post['user_email'] = trim($_post['user_email']);
    // Make sure user is valid
    if (jrCore_checktype($_post['user_email'], 'email')) {
        $_rt = jrCore_db_get_item_by_key('jrUser', 'user_email', $_post['user_email']);
    }
    else {
        $_rt = jrCore_db_get_item_by_key('jrUser', 'user_name', $_post['user_email']);
    }
    if (!$_rt || !is_array($_rt)) {
        jrCore_set_form_notice('error', 48);
        jrCore_form_result();
    }

    // Make sure account is not blocked
    if (isset($_rt['user_blocked']) && $_rt['user_blocked'] == 1) {
        jrCore_set_form_notice('error', 49);
        jrCore_form_result();
    }

    // Make sure account is active
    if (!isset($_rt['user_active']) || $_rt['user_active'] != 1) {
        jrCore_set_form_notice('error', 29);
        jrCore_form_result();
    }

    // See if this user is still pending activation
    if (!isset($_rt['user_validated']) || $_rt['user_validated'] != '1') {

        $_ln = jrUser_load_lang_strings();
        if (isset($_rt['quota_jrUser_signup_method']) && $_rt['quota_jrUser_signup_method'] == 'email') {
            // Give the user the ability to resend the activation email
            $_SESSION['allow_activation_resend'] = 1;
            $tmp                                 = jrCore_page_button('resend', $_ln['jrUser'][28], "jrCore_window_location('" . $_conf['jrCore_base_url'] . '/' . $_post['module_url'] . '/activation_resend/' . $_rt['_user_id'] . "')");
            jrCore_notice_page('error', '<p>' . $_ln['jrUser'][27] . '<br><br>' . $tmp . '</p>', $_conf['jrCore_base_url'], $_ln['jrCore'][87], false);
        }
        jrCore_notice_page('error', $_ln['jrUser'][27], $_conf['jrCore_base_url'], $_ln['jrCore'][87], false);
    }

    // Okay - this user is requesting a password reset:
    // - set a temp "reset" key
    // - send email to the address with the proper key URL
    // - user comes to form and resets password
    // - reset ALL user sessions/cookies for this user
    // - Send user an email letting them know their password was changed

    // New Entry
    $key = md5(microtime() . mt_rand());
    $tbl = jrCore_db_table_name('jrUser', 'forgot');
    $req = "INSERT INTO {$tbl} (forgot_user_id,forgot_time,forgot_key) VALUES ('{$_rt['_user_id']}',UNIX_TIMESTAMP(),'" . jrCore_db_escape($key) . "')";
    $uid = jrCore_db_query($req, 'INSERT_ID');
    if (!$uid || !jrCore_checktype($uid, 'number_nz')) {
        jrCore_set_form_notice('error', 36);
        jrCore_form_result();
    }

    // Send out password reset email
    $_rp = array(
        'system_name' => $_conf['jrCore_system_name'],
        'reset_url'   => "{$_conf['jrCore_base_url']}/{$_post['module_url']}/new_password/{$key}"
    );
    list($sub, $msg) = jrCore_parse_email_templates('jrUser', 'forgot', $_rp);
    jrCore_send_email($_rt['user_email'], $sub, $msg);

    // Our User Account is created...
    jrCore_logger('INF', "user: {$_rt['user_email']} has requested a password reset");

    jrCore_form_delete_session();
    if (!empty($_conf['jrUser_use_templates']) && $_conf['jrUser_use_templates'] == 'on') {
        jrCore_set_form_notice('success', 49);
        jrCore_form_result();
    }
    else {
        $_ln = jrUser_load_lang_strings();
        jrCore_notice_page('success', "<p>{$_ln['jrUser'][49]}</p>", $_conf['jrCore_base_url'], $_ln['jrCore'][87], false);
    }
}
