<?php
 /**
 * Jamroom Users module
 *
 * copyright 2025 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: ban_user_ip
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrUser_ban_user_ip($_post, $_user, $_conf)
{
    jrUser_admin_only();
    jrCore_validate_location_url();
    if (!isset($_post['ip']) || !jrCore_checktype($_post['ip'], 'ip_address')) {
        jrCore_json_response(array('error' => 'Invalid IP address'));
    }
    // Make sure we are not blocking our own IP
    if ($_post['ip'] == jrCore_get_ip() || strpos(' ' . jrCore_get_ip(), $_post['ip'])) {
        jrCore_json_response(array('error' => 'You cannot ban your own IP address!'));
    }
    // Make sure we are not blocking the server IP
    if (isset($_SERVER['SERVER_ADDR']) && $_post['ip'] == $_SERVER['SERVER_ADDR']) {
        jrCore_json_response(array('error' => 'You cannot ban your server IP address!'));
    }
    if (!jrCore_module_is_active('jrBanned')) {
        jrCore_json_response(array('error' => 'The Banned Items module is not installed or active'));
    }
    // OK we're good - we need to:
    // 1) Remove any SESSION for this IP address
    if ($_su = jrUser_session_online_user_info(7200)) {
        $_ds = array();
        foreach ($_su as $s) {
            if ($s['session_user_ip'] == $_post['ip']) {
                $_ds[] = $s['session_id'];
            }
        }
        if (count($_ds) > 0) {
            foreach ($_ds as $sid) {
                jrUser_session_delete_session_id($sid);
            }
        }
    }
    // 2) Add the IP Address as a Banned IP address
    $murl = jrCore_get_module_url('jrBanned');
    jrCore_location("{$_conf['jrCore_base_url']}/{$murl}/item_save/ban_type=ip/ban_value={$_post['ip']}");
}
