<?php
 /**
 * Jamroom Users module
 *
 * copyright 2025 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2012 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * jrUser_config
 */
function jrUser_config()
{
    // Enable Signups
    $_tmp = array(
        'name'     => 'signup_on',
        'type'     => 'checkbox',
        'default'  => 'on',
        'validate' => 'onoff',
        'label'    => 'User Signups',
        'help'     => 'Check this option to allow users to signup for your site.',
        'section'  => 'signup',
        'order'    => 1
    );
    jrCore_register_setting('jrUser', $_tmp);

    // Signup Notification
    $_tmp = array(
        'name'     => 'signup_notify',
        'type'     => 'checkbox',
        'default'  => 'on',
        'validate' => 'onoff',
        'label'    => 'Signup Notification',
        'help'     => 'If this option is checked the system will notify Admins when a new User Account is created.',
        'section'  => 'signup',
        'order'    => 2
    );
    jrCore_register_setting('jrUser', $_tmp);

    // authenticate
    $_tmp = array(
        'name'     => 'authenticate',
        'type'     => 'checkbox',
        'default'  => 'on',
        'validate' => 'onoff',
        'label'    => 'Re-Authenticate',
        'help'     => 'If this option is checked, when a user attempts to change their <strong>email address</strong> or <strong>password</strong> they will have to enter their existing password to continue.',
        'section'  => 'account',
        'order'    => 10
    );
    jrCore_register_setting('jrUser', $_tmp);

    // change notice
    $_tmp = array(
        'name'     => 'change_notice',
        'type'     => 'checkbox',
        'default'  => 'on',
        'validate' => 'onoff',
        'label'    => 'change notification',
        'help'     => 'If this option is checked and a user changes their email address or password they will be sent a notification to their <strong>old</strong> email address letting them know that their account information has been changed.',
        'section'  => 'account',
        'order'    => 11
    );
    jrCore_register_setting('jrUser', $_tmp);

    // change notice
    $_tmp = array(
        'name'     => 'allow_delete',
        'type'     => 'checkbox',
        'default'  => 'off',
        'validate' => 'onoff',
        'label'    => 'allow delete',
        'help'     => 'If this option is checked a &quot;delete account&quot; option will show in the User Settings',
        'section'  => 'account',
        'order'    => 12
    );
    jrCore_register_setting('jrUser', $_tmp);

    // Default Language
    $_tmp = array(
        'name'     => 'default_language',
        'default'  => 'en-US',
        'type'     => 'select',
        'options'  => 'jrUser_get_languages',
        'required' => 'on',
        'label'    => 'default language',
        'help'     => 'The Default language is the language that is setup for new user accounts by default.',
        'section'  => 'account',
        'order'    => 13
    );
    jrCore_register_setting('jrUser', $_tmp);

    // Max Login Time
    $_tmp = array(
        'name'     => 'session_expire_min',
        'default'  => 360,
        'type'     => 'text',
        'validate' => 'number_nz',
        'required' => 'on',
        'min'      => 10,
        'max'      => 20160,
        'label'    => 'session expiration',
        'help'     => 'How many minutes of inactivity will cause a User session to be marked as expired?',
        'section'  => 'sessions',
        'order'    => 20
    );
    jrCore_register_setting('jrUser', $_tmp);

    // Auto Login
    $_als = array(
        '1'  => 'Every Login (auto login disabled)',
        '7'  => 'Every 7 days',
        '2'  => 'Every 14 days',
        '30' => 'Every 30 days',
        '60' => 'Every 60 days',
        '90' => 'Every 90 days',
        '3'  => 'Permanent (until user resets cookies)'
    );
    $_tmp = array(
        'name'     => 'autologin',
        'default'  => '2',
        'type'     => 'select',
        'options'  => $_als,
        'required' => 'on',
        'label'    => 'auto login reset',
        'help'     => 'How often should a user have to re-enter their login credentials? If the user does not visit the site for the number of days selected here, they will need to login again.',
        'section'  => 'sessions',
        'order'    => 21
    );
    jrCore_register_setting('jrUser', $_tmp);

    // change notice
    $_tmp = array(
        'name'     => 'bot_sessions',
        'type'     => 'checkbox',
        'default'  => 'off',
        'validate' => 'onoff',
        'label'    => 'enable bot sessions',
        'help'     => 'If this option is checked, session tracking will be enable for Web Bots (such as Google bot, Bing bot, etc.). This allows the dashboard to display the number of bots online. Disable this to turn off bot sessions, which will use less system resources',
        'section'  => 'sessions',
        'order'    => 22
    );
    jrCore_register_setting('jrUser', $_tmp);

    $_opt = jrUser_get_session_system_plugins();
    if ($_opt && is_array($_opt) && count($_opt) > 1) {
        // Active Session System
        $_tmp = array(
            'name'     => 'active_session_system',
            'default'  => 'jrUser_mysql',
            'type'     => 'select',
            'options'  => $_opt,
            'validate' => 'core_string',
            'required' => 'on',
            'label'    => 'active session system',
            'help'     => 'What Session plugin should be the active session system?',
            'section'  => 'sessions',
            'order'    => 23
        );
        jrCore_register_setting('jrUser', $_tmp);
    }
    else {
        // Active Session System (hidden)
        $_tmp = array(
            'name'     => 'active_session_system',
            'default'  => 'jrUser_mysql',
            'type'     => 'hidden',
            'required' => 'on',
            'validate' => 'not_empty',
            'label'    => 'active session system',
            'help'     => 'This hidden field holds the name of the active session sub system - do not modify by hand'
        );
        jrCore_register_setting('jrUser', $_tmp);
    }

    // Site privacy options
    $_priv = array(
        '1' => 'Public (all pages visible)',
        '2' => 'Limited (site index and log in / signup only)',
        '3' => 'Private (no pages visible)'
    );
    $_tmp  = array(
        'name'     => 'site_privacy',
        'default'  => '1',
        'type'     => 'select',
        'options'  => $_priv,
        'required' => 'on',
        'label'    => 'Site Privacy',
        'help'     => 'Select which site pages visitors who are not logged in can see.<br><br><strong>NOTE:</strong> This setting only applies to users who are not logged in.',
        'section'  => 'site options',
        'order'    => 31
    );
    jrCore_register_setting('jrUser', $_tmp);

    // Notification layout
    $_opt = array('compact' => "Compact", 'expanded' => "Expanded");
    $_tmp = array(
        'name'     => 'notification_layout',
        'type'     => 'select',
        'default'  => 'compact',
        'options'  => $_opt,
        'label'    => 'Notification Layout',
        'sublabel' => 'for Account Settings -> Notifications',
        'help'     => 'The default is the compact layout that shows just one notificaiton option at a time. Expanded shows all the notification options on one screen.',
        'section'  => 'site options',
        'order'    => 32
    );
    jrCore_register_setting('jrUser', $_tmp);

    // Use Templates
    $_tmp = array(
        'name'     => 'use_templates',
        'type'     => 'checkbox',
        'default'  => 'off',
        'validate' => 'onoff',
        'label'    => 'Enable Templates',
        'sublabel' => 'For login and signup',
        'help'     => 'By default the login and signup screens use internally generated Forms, which allows for easy customization using the Form Designer.  If you would prefer to have 100% control over the login and signup pages, check this option and ensure the &quot;user_login.tpl&quot; and &quot;user_signup.tpl&quot; files are customized to suit your needs.',
        'section'  => 'site options',
        'order'    => 33
    );
    jrCore_register_setting('jrUser', $_tmp);

    // Login Note
    $_tmp = array(
        'name'     => 'login_note',
        'type'     => 'textarea',
        'validate' => 'allowed_html',
        'default'  => '',
        'required' => 'off',
        'label'    => 'login note',
        'sublabel' => 'HTML is allowed',
        'help'     => 'Enter a note that will be shown on the login page.',
        'section'  => 'notes',
        'order'    => 40
    );
    jrCore_register_setting('jrUser', $_tmp);

    // Signup Note
    $_tmp = array(
        'name'     => 'signup_note',
        'type'     => 'textarea',
        'validate' => 'allowed_html',
        'default'  => '',
        'required' => 'off',
        'label'    => 'signup note',
        'sublabel' => 'HTML is allowed',
        'help'     => 'Enter a note that will be shown on the signup page',
        'section'  => 'notes',
        'order'    => 41
    );
    jrCore_register_setting('jrUser', $_tmp);

    // Forgot Note
    $_tmp = array(
        'name'     => 'forgot_note',
        'type'     => 'textarea',
        'validate' => 'allowed_html',
        'default'  => '',
        'required' => 'off',
        'label'    => 'forgot note',
        'sublabel' => 'HTML is allowed',
        'help'     => 'Enter a note that will be shown on the forgot page',
        'section'  => 'notes',
        'order'    => 42
    );
    jrCore_register_setting('jrUser', $_tmp);

    // We no longer support forcing to SSL
    jrCore_delete_setting('jrUser', 'force_ssl');

    return true;
}

/**
 * Advanced Config keys
 */
function jrUser_advanced_config()
{
    // Define Advanced Config Keys
    jrCore_register_advanced_config_key('jrUser', 'session_expire_visitor', '', "Set to number of seconds 'sessions' will stick around for logged out users.");
    jrCore_register_advanced_config_key('jrUser', 'session_expire_bot', 900, "Set to number of seconds 'sessions' will stick around for bots.");
    jrCore_register_advanced_config_key('jrUser', 'login_activity_log', 'on', "Set to off to disable logging user logins to Activity Log");

    return true;
}
