<?php
 /**
 * Jamroom Item Tags module
 *
 * copyright 2023 The Jamroom Network
 *
 * This Jamroom file is LICENSED SOFTWARE, and cannot be redistributed.
 *
 * This Source Code is subject to the terms of the Jamroom Network
 * Commercial License -  please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: tag_save
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrTags_tag_save($_post, $_user, $_conf)
{
    jrUser_session_require_login();
    jrCore_validate_location_url();

    if (!jrCore_module_is_active($_post['tag_module'])) {
        return jrCore_json_response(array('error' => 'module being tagged is not active'));
    }
    if (!jrCore_db_get_prefix($_post['tag_module'])) {
        return jrCore_json_response(array('error' => 'module being tagged is not a datastore module'));
    }
    if (!jrCore_checktype($_post['tag_item_id'], 'number_nz')) {
        return jrCore_json_response(array('error' => 'invalid tag item_id'));
    }
    // Get the item info
    if (!$_ti = jrCore_db_get_item($_post['tag_module'], $_post['tag_item_id'], true)) {
        return jrCore_json_response(array('error' => 'invalid tag item_id - data does not exist'));
    }
    if (!jrCore_checktype($_post['tag_profile_id'], 'number_nz')) {
        return jrCore_json_response(array('error' => 'invalid tag profile_id'));
    }
    $_lang = jrUser_load_lang_strings();

    // Check for Wait Timer
    if (!jrUser_is_admin()) {
        if ($wait_timer = jrCore_get_config_value('jrTags', 'wait_time', 1)) {
            if (isset($_SESSION['jrTags_last_tag_timer']) && $_SESSION['jrTags_last_tag_timer'] > (time() - ($wait_timer * 60))) {
                return jrCore_json_response(array('error' => $_lang['jrTags'][19] . $wait_timer . 'm'));
            }
        }
    }
    $_SESSION['jrTags_last_tag_timer'] = time();

    // if its an array coming in run for each
    $_in   = array();
    $_tags = array();
    if (is_array($_post['tag_text'])) {
        foreach ($_post['tag_text'] as $tag) {
            $tag = jrTags_get_clean_tag($tag);
            if (!empty($tag)) {
                $_tags[] = $tag;
                $_in[]   = jrCore_db_escape($tag);
            }
        }
    }
    else {
        $tag     = jrTags_get_clean_tag($_post['tag_text']);
        $_tags[] = $tag;
        $_in[]   = jrCore_db_escape($tag);
    }

    $tag_module     = $_post['tag_module'];
    $tag_item_id    = (int) $_post['tag_item_id'];
    $tag_profile_id = (int) $_post['tag_profile_id'];

    // Get any EXISTING tags
    $tbl = jrCore_db_table_name('jrTags', 'tag_search');
    $req = "SELECT tag_value FROM {$tbl} WHERE tag_value IN('" . implode("','", $_in) . "') AND tag_item_id = {$tag_item_id} AND tag_module = '{$tag_module}'";
    $_ex = jrCore_db_query($req, 'tag_value', false, 'tag_value');

    $_create = array();
    foreach ($_tags as $tag_text) {

        // Check for banned words..
        if ($ban = jrCore_run_module_function('jrBanned_is_banned', 'word', $tag_text)) {
            return jrCore_json_response(array('error' => "{$_lang['jrCore'][67]} " . strip_tags($ban)));
        }

        // Check for valid text
        if (strlen($tag_text) < 3) {
            return jrCore_json_response(array('error' => $_lang['jrTags'][12]));
        }

        // Make sure we have not exceeded our max word count
        if (!jrUser_is_admin() && isset($_conf['jrTags_max_words']) && jrCore_checktype($_conf['jrTags_max_words'], 'number_nz') && str_word_count($tag_text) > $_conf['jrTags_max_words']) {
            return jrCore_json_response(array('error' => $_lang['jrTags'][17] . $_conf['jrTags_max_words']));
        }

        // Make sure we have not exceeded our max length (applies to admin as well since we have a DB restriction in place)
        if (isset($_conf['jrTags_max_length']) && jrCore_checktype($_conf['jrTags_max_length'], 'number_nz') && strlen($tag_text) > $_conf['jrTags_max_length']) {
            return jrCore_json_response(array('error' => $_lang['jrTags'][18] . $_conf['jrTags_max_length']));
        }

        // Does this tag already exists on this item?
        if (isset($_ex[$tag_text])) {
            continue;
        }

        // Create tag in tags table
        $_create[] = array(
            'm' => $tag_module,
            'p' => $tag_profile_id,
            'i' => $tag_item_id,
            't' => rawurldecode($tag_text),
        );
    }
    if (!empty($_create)) {
        foreach ($_create as $_t) {
            if (!jrTags_create_tag($_t['m'], $_t['p'], $_t['i'], $_t['t'])) {
                return jrCore_json_response(array('error' => $_lang['jrTags'][13]));
            }
        }
    }
    else {
        return jrCore_json_response(array('error' => 'No new tags found to save'));
    }

    // Reset profile tag cache
    $pid = $_ti['_profile_id'];
    switch ($tag_module) {
        case 'jrForum':
            $pid = $_ti['forum_profile_id'];
            break;
    }
    jrProfile_reset_cache($pid, 'jrTags');
    jrUser_reset_cache($_user['_user_id']);

    $_res = array(
        'tag_module'     => $tag_module,
        'tag_item_id'    => $tag_item_id,
        'tag_profile_id' => $tag_profile_id
    );
    return jrCore_json_response($_res);

}
