<?php
 /**
 * Jamroom Item Tags module
 *
 * copyright 2023 The Jamroom Network
 *
 * This Jamroom file is LICENSED SOFTWARE, and cannot be redistributed.
 *
 * This Source Code is subject to the terms of the Jamroom Network
 * Commercial License -  please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: existing_tags
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrTags_existing_tags($_post, $_user, $_conf)
{
    if (!isset($_post['tag_module']) || !jrCore_module_is_active($_post['tag_module'])) {
        return jrCore_json_response(array('error' => 'invalid tag module'));
    }
    $mod = $_post['tag_module'];
    if (!isset($_post['tag_item_id']) || !jrCore_checktype($_post['tag_item_id'], 'number_nz')) {
        return jrCore_json_response(array('error' => 'invalid tag item_id'));
    }
    $iid = (int) $_post['tag_item_id'];
    if (!$_it = jrCore_db_get_item($mod, $iid)) {
        return jrCore_json_response(array('error' => 'invalid tag item_id - data not found'));
    }
    if ($_tg = jrTags_get_tags_for_item($mod, $iid)) {
        $_rt = array(
            '_item' => $_it,
            '_tags' => $_tg
        );
        // allow the module to define the correct location for just added tags.
        $turl = '';
        if (isset($_post['base_url']) && substr($_post['base_url'], -1) == '/') {
            $turl = $_post['base_url'];
        }
        foreach ($_tg as $k => $v) {
            $_rt['_tags'][$k]['tag_url']  = $turl . $v['tag_value'];
            $_rt['_tags'][$k]['tag_text'] = rawurldecode($v['tag_value']);
        }
        $html = jrCore_parse_template('existing_tags.tpl', $_rt, 'jrTags');
        return jrCore_json_response(array('html' => $html), true, false);
    }
    return jrCore_json_response(array('html' => ''));
}
