<?php
 /**
 * Jamroom Item Tags module
 *
 * copyright 2023 The Jamroom Network
 *
 * This Jamroom file is LICENSED SOFTWARE, and cannot be redistributed.
 *
 * This Source Code is subject to the terms of the Jamroom Network
 * Commercial License -  please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: default
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrTags_default($_post, $_user, $_conf)
{
    global $_urls;

    // If we are not enabled - 404
    if (jrCore_get_config_value('jrTags', 'enable_cloud', 'on') == 'off') {
        jrCore_page_not_found();
    }

    $_ln = jrUser_load_lang_strings();

    // System wide Tag Cloud
    $_md = array();
    foreach (jrCore_get_datastore_modules() as $m => $p) {
        if (jrTags_is_disabled_module($m)) {
            continue;
        }
        if (jrCore_module_is_active($m)) {
            $_md[] = jrCore_db_escape($m);
        }
    }
    if (empty($_post['option'])) {

        $_tm = array(
            'show_title' => false,
            'show_all'   => false,
            'tabs'       => array()
        );

        $tbl = jrCore_db_table_name('jrTags', 'tag_search');
        $req = "SELECT tag_module FROM {$tbl} WHERE tag_module IN('" . implode("','", $_md) . "') GROUP BY tag_module";
        $_tb = jrCore_db_query($req, 'tag_module', false, 'tag_module');
        if ($_tb && is_array($_tb)) {

            // Get "ALL Tags" tab
            $_tm['tabs']['jrTags'] = array(
                'id'     => 'tag-0',
                'class'  => 'page_tab',
                'label'  => $_ln['jrTags'][21],
                'url'    => $_conf['jrCore_base_url'] . '/' . $_post['module_url'],
                'active' => 1
            );

            $k = 1;
            foreach ($_tb as $mod) {
                if (jrTags_is_disabled_module($mod)) {
                    continue;
                }
                if (jrCore_module_is_active($mod)) {
                    if ($mod == 'jrProfile') {
                        $label = $_ln['jrProfile'][2];
                    }
                    else {
                        $label = (isset($_ln[$mod]['menu']) && strlen($_ln[$mod]['menu']) > 2) ? $_ln[$mod]['menu'] : $mod;
                    }
                    $_tm['tabs'][$mod] = array(
                        'id'    => "tag-" . $k,
                        'class' => 'page_tab',
                        'label' => $label,
                        'url'   => $_conf['jrCore_base_url'] . '/' . $_post['module_url'] . '/' . jrCore_get_module_url($mod)
                    );
                    $k++;
                }
            }
        }
        jrCore_page_title($_ln['jrTags'][6] . ': ' . $_ln['jrTags'][10]);
        $out = jrCore_parse_template('header.tpl', $_tm);
        $out .= jrCore_parse_template('header.tpl', $_tm, 'jrTags');
        $out .= jrCore_parse_template('profile_tabs.tpl', $_tm, 'jrProfile');
        $out .= jrCore_parse_template('index.tpl', $_post, 'jrTags');
        return $out;
    }

    // All Tags Cloud for specific module
    elseif (isset($_urls["{$_post['option']}"]) && (!isset($_post['_1']) || strlen($_post['_1']) === 0)) {

        $mod = $_urls["{$_post['option']}"];

        $_tm = array(
            'show_title' => false,
            'show_all'   => false,
        );

        // Get "ALL Tags" tab
        $_tm['tabs'] = array(
            'jrTags' => array(
                'id'    => 'tag-0',
                'class' => 'page_tab',
                'label' => $_ln['jrTags'][21],
                'url'   => $_conf['jrCore_base_url'] . '/' . $_post['module_url']
            )
        );

        $tbl = jrCore_db_table_name('jrTags', 'tag_search');
        $req = "SELECT tag_module FROM {$tbl} WHERE tag_module IN('" . implode("','", $_md) . "') GROUP BY tag_module";
        $_tb = jrCore_db_query($req, 'tag_module', false, 'tag_module');
        if ($_tb && is_array($_tb)) {
            $k = 1;
            foreach ($_tb as $m) {
                if (jrCore_module_is_active($m)) {
                    if (jrTags_is_disabled_module($m)) {
                        continue;
                    }
                    if ($m == 'jrProfile') {
                        $label = $_ln['jrProfile'][2];
                    }
                    else {
                        $label = (isset($_ln[$m]['menu']) && strlen($_ln[$m]['menu']) > 2) ? $_ln[$m]['menu'] : $m;
                    }
                    $_tm['tabs'][$m] = array(
                        'id'    => "tag-" . $k,
                        'class' => 'page_tab',
                        'label' => $label,
                        'url'   => $_conf['jrCore_base_url'] . '/' . $_post['module_url'] . '/' . jrCore_get_module_url($m)
                    );
                    if ($m == $mod) {
                        jrCore_page_title($_ln['jrTags'][6] . ': ' . $label);
                        $_tm['tabs'][$mod]['active'] = 1;
                    }
                }
                $k++;
            }
        }

        $out = jrCore_parse_template('header.tpl', $_tm);
        $out .= jrCore_parse_template('header.tpl', $_tm, 'jrTags');
        $out .= jrCore_parse_template('profile_tabs.tpl', $_tm, 'jrProfile');

        $_post['tag_module'] = $mod;
        $out                 .= jrCore_parse_template('index.tpl', $_post, 'jrTags');
        return $out;
    }

    //------------------------------
    // Fall through = specific tag
    // (ALL or per module)
    //------------------------------
    $order_by = (isset($_post['order_by']) && strlen($_post['order_by']) > 2) ? $_post['order_by'] : false;

    $tab = 'jrTags';
    $tbl = jrCore_db_table_name('jrTags', 'tag_search');
    if (!isset($_urls["{$_post['option']}"])) {
        // Tag across ALL modules
        $url = $_post['option'];
        $req = "SELECT * FROM {$tbl} WHERE tag_value = '" . jrCore_db_escape($_post['option']) . "' AND tag_module IN('" . implode("','", $_md) . "')";
    }
    else {
        // Tag from specific module
        $url = "{$_post['option']}/{$_post['_1']}";
        $mod = jrCore_db_escape($_urls["{$_post['option']}"]);
        $req = "SELECT * FROM {$tbl} WHERE tag_value = '" . jrCore_db_escape(rawurlencode($_post['_1'])) . "' AND tag_module = '{$mod}'";
        $tab = $mod;
    }
    $req .= " ORDER BY tag_id DESC";
    $_rt = jrCore_db_query($req, 'NUMERIC');
    if (!$_rt || !is_array($_rt)) {
        return jrCore_page_not_found();
    }

    // skin header
    jrCore_page_title($_ln['jrTags'][7] . ': ' . rawurldecode($_rt[0]['tag_value']));
    $out = jrCore_parse_template('header.tpl', $_post);

    // tabs and order
    $_tmp = array(
        'show_title'   => true,
        'show_all'     => true,
        'tag_text'     => rawurldecode($_rt[0]['tag_value']),
        'tag_url'      => $url,
        'this_url'     => jrCore_strip_url_params(jrCore_get_current_url(), array('order_by')),
        'order_by'     => $order_by,
        'murl'         => $_post['module_url'],
        'tabs'         => array(),
        'active_label' => ': ' . $_ln['jrTags'][10]
    );

    // Get "ALL Tags" tab
    $_tmp['tabs']['jrTags'] = array(
        'id'    => 'tag-0',
        'class' => 'page_tab',
        'label' => $_ln['jrTags'][21],
        'url'   => $_conf['jrCore_base_url'] . '/' . $_post['module_url'] . '/' . $url
    );

    $cnt = 1;
    foreach ($_rt as $t) {
        $mod = $t['tag_module'];
        if (!isset($_tmp['tabs'][$mod])) {
            if ($mod == 'jrProfile') {
                $label = $_ln['jrProfile'][2];
            }
            else {
                $label = (strlen($_ln[$mod]['menu']) > 2) ? $_ln[$mod]['menu'] : $mod;
            }
            $_tmp['tabs'][$mod] = array(
                'id'    => "tag-{$cnt}",
                'class' => 'page_tab',
                'label' => $label,
                'url'   => $_conf['jrCore_base_url'] . '/' . $_post['module_url'] . '/' . jrCore_get_module_url($mod) . '/' . $url
            );
        }
    }
    $_tmp['tabs'][$tab]['active'] = 1;

    $out .= jrCore_parse_template('header.tpl', $_tmp, 'jrTags');
    $out .= jrCore_parse_template('profile_tabs.tpl', $_tmp, 'jrProfile');

    // Parse actual item_list.tpl files...
    $_itm = array();
    foreach ($_rt as $t) {
        $mod = $t['tag_module'];
        $iid = (int) $t['tag_item_id'];
        if (!isset($_itm[$mod])) {
            $_itm[$mod] = array();
        }
        $_itm[$mod][$iid] = $iid;
    }

    $_tmp = array();
    foreach ($_itm as $mod => $_ids) {
        $_sp = array(
            'search'                       => array(
                '_item_id in ' . implode(',', $_ids)
            ),
            'exclude_jrUser_keys'          => true,
            'exclude_jrProfile_quota_keys' => true,
            'index_key'                    => '_item_id',
            'limit'                        => count($_ids)
        );
        $_sp = jrCore_db_search_items($mod, $_sp);
        if ($_sp && is_array($_sp) && isset($_sp['_items'])) {
            $_tmp[$mod] = $_sp['_items'];
        }
    }
    $content = '';
    if (count($_tmp) > 0) {
        foreach ($_rt as $t) {
            $mod = $t['tag_module'];
            $iid = (int) $t['tag_item_id'];
            if (isset($_tmp[$mod][$iid])) {
                $_rp     = array(
                    '_items' => array($_tmp[$mod][$iid])
                );
                $content .= jrCore_parse_template('item_list.tpl', $_rp, $mod);
            }
        }
    }
    if (strlen($content) === 0) {
        $content = $_ln['jrTags'][25];
    }
    $_rt['item_list_content'] = $content;

    $out .= jrCore_parse_template('tag_list.tpl', $_rt, 'jrTags');
    $out .= jrCore_parse_template('list_pager.tpl', $_rt, 'jrCore');
    $out .= jrCore_parse_template('footer.tpl', $_tmp, 'jrTags');
    $out .= jrCore_parse_template('footer.tpl');
    return $out;
}
