<?php
 /**
 * Jamroom Item Tags module
 *
 * copyright 2023 The Jamroom Network
 *
 * This Jamroom file is LICENSED SOFTWARE, and cannot be redistributed.
 *
 * This Source Code is subject to the terms of the Jamroom Network
 * Commercial License -  please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2012 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

//------------------------------
// default
//------------------------------
function profile_view_jrTags_default($_profile, $_post, $_user, $_conf)
{
    // ALL Items tagged with a specific tag belonging to a profile_id
    $pid  = (int) $_profile['_profile_id'];
    $page = 1;
    if (isset($_post['p']) && jrCore_checktype($_post['p'], 'number_nz')) {
        $page = (int) $_post['p'];
    }

    $pagebreak = 12;
    if (isset($_post['pagebreak']) && jrCore_checktype($_post['pagebreak'], 'number_nz')) {
        $pagebreak = (int) $_post['pagebreak'];
    }

    $_md = array();
    foreach (jrCore_get_datastore_modules() as $m => $p) {
        if (jrCore_module_is_active($m)) {
            $_md[] = jrCore_db_escape($m);
        }
    }
    $tbl = jrCore_db_table_name('jrTags', 'tag_search');
    if (isset($_post['option']) && strlen($_post['option']) > 2) {
        $req = "SELECT * FROM {$tbl} WHERE tag_value = '" . jrCore_db_escape(rawurlencode($_post['option'])) . "' AND tag_profile_id = {$pid}";
    }
    else {
        $req = "SELECT * FROM {$tbl} WHERE tag_profile_id = {$pid}";
    }
    $req .= " AND tag_module IN('" . implode("','", $_md) . "') ORDER BY tag_id DESC";
    $_rt = jrCore_db_paged_query($req, $page, $pagebreak, 'NUMERIC', null, null, false);

    // header
    if ($_rt && is_array($_rt) && isset($_rt['_items'])) {
        $_profile['tag_url']  = $_rt['_items'][0]['tag_value'];
        $_profile['tag_text'] = rawurldecode($_rt['_items'][0]['tag_value']);
    }
    $out = jrCore_parse_template('profile_header.tpl', $_profile, 'jrTags');

    // Get items
    if ($_rt && is_array($_rt) && isset($_rt['_items'])) {
        $_it = array();
        foreach ($_rt['_items'] as $t) {
            $mod = $t['tag_module'];
            $iid = $t['tag_item_id'];
            if (!isset($_it[$mod])) {
                $_it[$mod] = array();
            }
            $_it[$mod][$iid] = $iid;
        }
        if (count($_it) > 0) {
            foreach ($_it as $mod => $_ids) {
                $_sp = array(
                    'search'              => array(
                        '_item_id in ' . implode(',', $_ids)
                    ),
                    'exclude_jrUser_keys' => true,
                    'index_key'           => '_item_id',
                    'limit'               => count($_ids)
                );
                $_sp = jrCore_db_search_items($mod, $_sp);
                if ($_sp && is_array($_sp) && !empty($_sp['_items'])) {
                    $_it[$mod] = $_sp['_items'];
                }
            }
            foreach ($_rt['_items'] as $t) {
                $mod = $t['tag_module'];
                $iid = $t['tag_item_id'];
                if (isset($_it[$mod][$iid])) {
                    $_rp = array(
                        '_items' => array(
                            0 => $_it[$mod][$iid]
                        )
                    );
                    $out .= jrCore_parse_template('item_list.tpl', $_rp, $mod);
                }
            }
        }
        $out .= jrCore_parse_template('list_pager.tpl', $_rt, 'jrCore');
    }
    $out .= jrCore_parse_template('profile_footer.tpl', array(), 'jrTags');
    return $out;
}
