<?php
 /**
 * Jamroom Javascript Event Logger module
 *
 * copyright 2023 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2012 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * meta
 */
function jrScriptLogger_meta()
{
    return array(
        'name'        => 'Javascript Event Logger',
        'url'         => 'el',
        'version'     => '1.0.3',
        'developer'   => 'The Jamroom Network, &copy;' . date('Y'),
        'description' => 'Logs Javascript events to the Activity Log',
        'license'     => 'mpl',
        'category'    => 'developer'
    );
}

/**
 * init
 */
function jrScriptLogger_init()
{
    // Trace Kit JS
    jrCore_register_module_feature('jrCore', 'javascript', 'jrScriptLogger', APP_DIR . '/modules/jrScriptLogger/contrib/tracekit/tracekit.min.js');

    // We listen for our various page display triggers
    jrCore_register_module_feature('jrCore', 'javascript', 'jrScriptLogger', true);
    jrCore_register_event_listener('jrCore', 'view_results', 'jrScriptLogger_view_results_listener');
    return true;
}

//-------------------------------
// EVENT LISTENERS
//-------------------------------

/**
 * Insert Error logging if enabled
 * @param $_data string incoming HTML
 * @param $_user array current user info
 * @param $_conf array Global config
 * @param $_args array additional info about the module
 * @param $event string Event Trigger name
 * @return string
 */
function jrScriptLogger_view_results_listener($_data, $_user, $_conf, $_args, $event)
{
    if (jrCore_is_view_request()) {
        if (jrCore_get_config_value('jrScriptLogger', 'enabled', 'off') == 'on') {
            $script = trim(jrCore_parse_template('event.tpl', array('events' => 'error'), 'jrScriptLogger'));
            $_data  = str_replace('</head>', "{$script}\n</head>", $_data);
        }
    }
    return $_data;
}
