<?php
 /**
 * Jamroom Redis Cache module
 *
 * copyright 2025 The Jamroom Network
 *
 * This Jamroom file is LICENSED SOFTWARE, and cannot be redistributed.
 *
 * This Source Code is subject to the terms of the Jamroom Network
 * Commercial License -  please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: server_update
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrRedis_server_update($_post, $_user, $_conf)
{
    jrUser_master_only();

    if (!isset($_post['id']) || !jrCore_checktype($_post['id'], 'number_nz')) {
        jrCore_set_form_notice('error', 'invalid server id');
        jrCore_location('referrer');
    }
    $_ap = jrRedis_get_server_by_id($_post['id']);
    if (!$_ap || !is_array($_ap)) {
        jrCore_set_form_notice('error', 'invalid server id');
        jrCore_location('referrer');
    }

    jrCore_page_include_admin_menu();
    jrCore_page_admin_tabs('jrRedis', 'server_browse');
    jrCore_page_banner('modify server');

    jrCore_get_form_notice();

    // Form init
    $_tmp = array(
        'submit_value' => 'save changes',
        'cancel'       => "{$_conf['jrCore_base_url']}/{$_post['module_url']}/server_browse",
        'values'       => $_ap
    );
    jrCore_form_create($_tmp);

    // ID
    $_tmp = array(
        'name'  => 'id',
        'type'  => 'hidden',
        'value' => $_post['id']
    );
    jrCore_form_field_create($_tmp);

    // Server Host
    $_tmp = array(
        'name'     => 'server_host',
        'label'    => 'hostname / IP address',
        'help'     => 'Enter the IP Address or Host for this Redis server',
        'type'     => 'text',
        'validate' => 'printable',
        'required' => true
    );
    jrCore_form_field_create($_tmp);

    // Server Port
    $_tmp = array(
        'name'     => 'server_port',
        'label'    => 'port',
        'help'     => 'Enter the port the Redis server is running on',
        'type'     => 'text',
        'validate' => 'number_nz',
        'default'  => 6379,
        'required' => true
    );
    jrCore_form_field_create($_tmp);

    // Server Password
    $_tmp = array(
        'name'     => 'server_pass',
        'label'    => 'password',
        'help'     => 'Enter the password that is used to connect to this Redis Server',
        'type'     => 'password',
        'validate' => 'not_empty',
        'required' => false
    );
    jrCore_form_field_create($_tmp);

    // Server Cache
    $_tmp = array(
        'name'     => 'server_cache',
        'label'    => 'cache support',
        'help'     => 'Check this option to make this Redis Server accept CACHE requests',
        'type'     => 'checkbox',
        'validate' => 'onoff',
        'required' => true
    );
    jrCore_form_field_create($_tmp);

    // Server Session
    $_tmp = array(
        'name'     => 'server_session',
        'label'    => 'session support',
        'help'     => 'Check this option to make this Redis Server accept SESSION requests',
        'type'     => 'checkbox',
        'validate' => 'onoff',
        'required' => true
    );
    jrCore_form_field_create($_tmp);
    jrCore_page_display();
}
