<?php
 /**
 * Jamroom Redis Cache module
 *
 * copyright 2025 The Jamroom Network
 *
 * This Jamroom file is LICENSED SOFTWARE, and cannot be redistributed.
 *
 * This Source Code is subject to the terms of the Jamroom Network
 * Commercial License -  please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2003 - 2018 Talldude Networks, LLC.
 * @noinspection PhpElementIsNotAvailableInCurrentPhpVersionInspection
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * meta
 */
function jrRedis_meta()
{
    return array(
        'name'        => 'Redis Cache',
        'url'         => 'redis',
        'version'     => '1.4.0',
        'developer'   => 'The Jamroom Network, &copy;' . date('Y'),
        'description' => 'Adds core cache and user session support for Redis - http://redis.io',
        'category'    => 'site',
        'requires'    => 'jrCore:6.5.12',
        'needs'       => 'class:Redis',
        'license'     => 'jcl'
    );
}

/**
 * init
 */
function jrRedis_init()
{
    // trigger for when we fail to connect
    jrCore_register_event_trigger('jrRedis', 'redis_connect_error', 'Fired when unable to connect to a Redis server');
    jrCore_register_event_trigger('jrRedis', 'get_configured_servers', 'Fired with array of configured Redis servers before connection');

    // Our info tool
    jrCore_register_module_feature('jrCore', 'tool_view', 'jrRedis', 'server_browse', array('Server Browser', 'Create, Update and Delete configured Redis Servers'));
    jrCore_register_module_feature('jrCore', 'tool_view', 'jrRedis', 'server_info', array('Server Stats', 'View Redis Server runtime information'));

    jrCore_register_module_feature('jrCore', 'admin_tab', 'jrRedis', 'server_browse', 'Server Browser');
    jrCore_register_module_feature('jrCore', 'admin_tab', 'jrRedis', 'server_info', 'Server Stats');

    // Register our plugins
    jrCore_register_system_plugin('jrRedis', 'cache', 'redis', 'Redis Data Cache');
    jrCore_register_system_plugin('jrRedis', 'session', 'redis', 'Redis Sessions');

    jrCore_register_event_trigger('jrRedis', 'session_meta_data', 'Fired with session meta data before saving');
    jrCore_register_event_trigger('jrRedis', 'session_online_user_info', 'Fired in online_user_info call with session meta data');

    jrCore_register_event_listener('jrCore', 'system_check', 'jrRedis_system_check_listener');

    // define our TYPE map
    // array(<instance:c|s>, db#)
    // c = cache
    // s = session
    $_map = array(
        'cache'        => array('c', 0),
        'session'      => array('s', 1),
        'form_session' => array('s', 2),
        'key_cache'    => array('c', 3),
        'image_cache'  => array('c', 4),
        'counter'      => array('s', 5),
        'flag'         => array('s', 6)
    );
    jrCore_set_flag('jrredis_db_map', $_map);
    return true;
}

// Include Library
require_once APP_DIR . '/modules/jrRedis/lib/cache.php';
require_once APP_DIR . '/modules/jrRedis/lib/counter.php';
require_once APP_DIR . '/modules/jrRedis/lib/flag.php';
require_once APP_DIR . '/modules/jrRedis/lib/form.php';
require_once APP_DIR . '/modules/jrRedis/lib/functions.php';
require_once APP_DIR . '/modules/jrRedis/lib/key_cache.php';
require_once APP_DIR . '/modules/jrRedis/lib/modal.php';
require_once APP_DIR . '/modules/jrRedis/lib/session.php';

/**
 * Make sure php-redis is installed
 * @param $_data array incoming data array
 * @param $_user array current user info
 * @param $_conf array Global config
 * @param $_args array additional info about the module
 * @param $event string Event Trigger name
 * @return array
 */
function jrRedis_system_check_listener($_data, $_user, $_conf, $_args, $event)
{
    // We require PECL Redis
    if (!class_exists('Redis')) {
        $dat             = array();
        $dat[1]['title'] = 'required functions';
        $dat[1]['class'] = 'center';
        $dat[2]['title'] = 'are configured';
        $dat[2]['class'] = 'center';
        $dat[3]['title'] = jrCore_get_option_image('fail');
        $dat[3]['class'] = 'center';
        $dat[4]['title'] = 'Unable to load php-redis functions - ensure Redis support is enabled in PHP';
        jrCore_page_table_row($dat);
    }
    return $_data;
}
