<?php
 /**
 * Jamroom URL Redirection module
 *
 * copyright 2023 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: update_save
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrRedirect_update_save($_post, $_user, $_conf)
{
    jrUser_master_only();
    jrCore_form_validate($_post);

    // Make sure it is not a function
    if (function_exists("view_jrRedirect_{$_post['name']}")) {
        jrCore_set_form_notice('error', "Invalid view name - please use another");
        jrCore_form_result();
    }
    if (!isset($_post['id']) || !jrCore_checktype($_post['id'], 'number_nz')) {
        jrCore_set_form_notice('error', 'invalid rule id - please try again');
        jrCore_form_result();
    }
    $_rt = jrCore_db_get_item('jrRedirect', $_post['id'], true);
    if (!$_rt || !is_array($_rt)) {
        jrCore_set_form_notice('error', 'invalid rule id - please try again');
        jrCore_form_result();
    }
    $_sv = jrCore_form_get_save_data('jrRedirect', 'update', $_post);
    if (jrCore_db_update_item('jrRedirect', $_post['id'], $_sv)) {
        jrCore_form_delete_session();
        jrCore_set_form_notice('success', 'The rule has been successfully updated');
    }
    else {
        jrCore_set_form_notice('error', 'An error was encountered updating the rule - please try again');
    }
    jrCore_form_result();
}
