<?php
 /**
 * Jamroom URL Redirection module
 *
 * copyright 2023 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: browse
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrRedirect_browse($_post, $_user, $_conf)
{
    jrUser_master_only();
    jrCore_page_include_admin_menu();
    jrCore_page_admin_tabs('jrRedirect', 'browse');
    jrCore_page_banner('redirect rule browser');
    jrCore_get_form_notice();

    $dat             = array();
    $dat[1]['title'] = 'match&nbsp;view';
    $dat[1]['width'] = '30%';
    $dat[2]['title'] = 'URL';
    $dat[2]['width'] = '45%';
    $dat[3]['title'] = 'views';
    $dat[3]['width'] = '10%';
    $dat[4]['title'] = 'graph';
    $dat[4]['width'] = '5%';
    $dat[5]['title'] = 'modify';
    $dat[5]['width'] = '5%';
    $dat[6]['title'] = 'delete';
    $dat[6]['width'] = '5%';
    jrCore_page_table_header($dat);

    if (!isset($_post['p']) || !jrCore_checktype($_post['p'], 'number_nz')) {
        $_post['p'] = 1;
    }
    $pagebreak = jrCore_get_pager_rows();

    $_sc = array(
        'order_by'       => array(
            '_item_id' => 'numerical_desc'
        ),
        'skip_triggers'  => true,
        'privacy_check'  => false,
        'ignore_pending' => true,
        'page'           => (int) $_post['p'],
        'no_cache'       => true,
        'pagebreak'      => $pagebreak
    );

    $_rt = jrCore_db_search_items('jrRedirect', $_sc);
    if ($_rt && is_array($_rt) && isset($_rt['_items'])) {

        $_id = array();
        foreach ($_rt['_items'] as $_rule) {
            $_id[] = (int) $_rule['_item_id'];
        }
        // Get stats
        $tbl = jrCore_db_table_name('jrRedirect', 'stats');
        $req = "SELECT stat_redirect_id, SUM(stat_value) AS ttl FROM {$tbl} WHERE stat_redirect_id IN(" . implode(',', $_id) . ") GROUP BY stat_redirect_id";
        $_st = jrCore_db_query($req, 'stat_redirect_id', false, 'ttl');

        foreach ($_rt['_items'] as $k => $_rule) {
            $rid             = (int) $_rule['_item_id'];
            $dat             = array();
            $dat[1]['title'] = "<a href=\"{$_conf['jrCore_base_url']}/{$_post['module_url']}/{$_rule['r_view']}\" target=\"_blank\">{$_rule['r_view']}</a>";
            $dat[1]['class'] = 'center';
            $dat[2]['title'] = '<a href="' . $_rule['r_url'] . '" target="_blank" rel="noreferrer noopener">' . $_rule['r_url'] . '</a>';
            $dat[2]['class'] = 'center';
            $dat[3]['title'] = (isset($_st[$rid])) ? jrCore_number_format($_st[$rid]) : 0;
            $dat[3]['class'] = 'center';
            $dat[4]['title'] = "<a href=\"{$_conf['jrCore_base_url']}/{$_post['module_url']}/graph/redirects_by_day/id={$_rule['_item_id']}\" onclick=\"jrGraph_modal_graph('#rb-graph{$k}','{$_post['module_url']}','redirects_by_day'); return false\">" . jrCore_get_sprite_html('stats') . "</a><div id=\"rb-graph{$k}\" style=\"width:750px;height:400px;display:none;bottom:0;\"></div>";
            $dat[4]['class'] = 'center';
            $dat[5]['title'] = jrCore_page_button("rb-modify-{$k}", 'modify', "jrCore_window_location('{$_conf['jrCore_base_url']}/{$_post['module_url']}/update/id={$_rule['_item_id']}')");
            $dat[6]['title'] = jrCore_page_button("rb-delete-{$k}", 'delete', "jrCore_confirm('', 'Are you sure you want to delete this redirected URL?', function() { jrCore_window_location('{$_conf['jrCore_base_url']}/{$_post['module_url']}/delete_save/id={$_rule['_item_id']}') } )");
            jrCore_page_table_row($dat);
        }
        jrCore_page_table_pager($_rt);
    }
    else {
        $dat             = array();
        $dat[1]['title'] = "<p>no Redirect URL rules have been created yet - create one below.</p>";
        $dat[1]['class'] = 'center';
        jrCore_page_table_row($dat);
    }
    jrCore_page_table_footer();

    // Form init
    $_tmp = array(
        'submit_value'     => 'create new URL redirect rule',
        'cancel'           => "{$_conf['jrCore_base_url']}/{$_post['module_url']}/admin/tools",
        'form_ajax_submit' => false
    );
    jrCore_form_create($_tmp);

    // Title
    $_tmp = array(
        'name'     => 'r_view',
        'label'    => 'match view',
        'help'     => "Enter the view name that will be matched - i.e.<br><br>{$_conf['jrCore_base_url']}/{$_post['module_url']}/[view]",
        'type'     => 'text',
        'validate' => 'not_empty',
        'required' => true,
        'section'  => 'create a new redirected URL'
    );
    jrCore_form_field_create($_tmp);

    // Match
    $_tmp = array(
        'name'     => 'r_url',
        'label'    => 'redirected to URL',
        'help'     => 'Enter the URL the user will be redirected to when they view the matched view.',
        'type'     => 'text',
        'validate' => 'url',
        'required' => true
    );
    jrCore_form_field_create($_tmp);
    jrCore_page_display();
}
