<?php
 /**
 * Jamroom Profile Tweaks module
 *
 * copyright 2023 The Jamroom Network
 *
 * This Jamroom file is LICENSED SOFTWARE, and cannot be redistributed.
 *
 * This Source Code is subject to the terms of the Jamroom Network
 * Commercial License -  please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: customize_save
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrProfileTweaks_customize_save($_post, $_user, $_conf)
{
    // Must be logged in
    jrUser_session_require_login();
    jrCore_form_validate($_post);
    jrUser_check_quota_access('jrProfileTweaks');

    // See if we have an image
    $own = true;
    $pid = $_user['user_active_profile_id'];
    if (jrUser_is_admin() && isset($_post['pid']) && jrCore_checktype($_post['pid'], 'number_nz')) {
        $own = false;
        $pid = $_post['pid'];
    }
    // get info about this profile
    $_pr = jrCore_db_get_item('jrProfile', $pid, false, true);

    $_data = array();

    // Logo
    $_image = jrCore_get_uploaded_media_files('jrProfileTweaks', 'profile_logo_image');
    if (is_array($_image)) {

        if (is_file("{$_image[0]}.tmp")) {
            $name = file_get_contents("{$_image[0]}.tmp");
            if ($ext = jrCore_file_extension($name)) {

                // If we have an existing image, delete it first
                if (isset($_pr['profile_logo_image_size']) && jrCore_checktype($_pr['profile_logo_image_size'], 'number_nz')) {
                    jrCore_delete_media_file($pid, "jrProfile_{$pid}_profile_logo_image." . $_pr['profile_logo_image_extension']);
                }

                $_data['profile_logo_image_extension'] = $ext;
                $_data['profile_logo_image_name']      = $name;
                $_data['profile_logo_image_size']      = filesize($_image[0]);
                $_data['profile_logo_image_time']      = time();
                $_data['profile_logo_image_type']      = jrCore_mime_type($_image[0]);
                jrCore_write_media_file($pid, "jrProfile_{$pid}_profile_logo_image.{$ext}", $_image[0], 'public-read');
            }
        }
    }

    // Background image
    $_image = jrCore_get_uploaded_media_files('jrProfileTweaks', 'profile_bg_image');
    if (is_array($_image)) {

        if (is_file("{$_image[0]}.tmp")) {
            $name = file_get_contents("{$_image[0]}.tmp");
            if (jrCore_file_extension($name)) {

                // If we have an existing image, delete it first
                if (isset($_pr['profile_bg_image_size']) && jrCore_checktype($_pr['profile_bg_image_size'], 'number_nz')) {
                    jrCore_delete_media_file($pid, "jrProfile_{$pid}_profile_bg_image.jpg");
                }

                // We have an uploaded image - we don't want to save a massive background file,
                // so we're going to resize it here if it is larger than 2560px height/width
                list($iw, $ih) = getimagesize($_image[0]);
                if (isset($iw) && $iw > 2560 || isset($ih) && $ih > 2560) {
                    jrImage_resize_image($_image[0], $_image[0], 2560);
                }

                $_data['profile_bg_image_extension'] = 'jpg';
                $_data['profile_bg_image_name']      = $name;
                $_data['profile_bg_image_size']      = filesize($_image[0]);
                $_data['profile_bg_image_time']      = time();
                $_data['profile_bg_image_type']      = 'image/jpeg';
                jrCore_write_media_file($pid, "jrProfile_{$pid}_profile_bg_image.jpg", $_image[0], 'public-read');
            }
        }
    }

    // See if we are changing the tiling
    if (!empty($_post['profile_bg_tile'])) {
        $_data['profile_bg_tile'] = $_post['profile_bg_tile'];
    }

    // INDEX
    if (isset($_user['quota_jrProfileTweaks_allow_index_redirect']) && $_user['quota_jrProfileTweaks_allow_index_redirect'] == 'on') {
        if (isset($_post['profile_index_page']) && strlen($_post['profile_index_page']) > 0) {
            $_data['profile_index_page'] = $_post['profile_index_page'];
        }
        else {
            jrCore_db_delete_item_key('jrProfile', $pid, 'profile_index_page');
        }
    }
    else {
        jrCore_db_delete_item_key('jrProfile', $pid, 'profile_index_page');
    }

    // SKIN
    if (isset($_user['quota_jrProfileTweaks_allow_skin']) && strlen($_user['quota_jrProfileTweaks_allow_skin']) > 0) {

        if (isset($_post['profile_custom_skin']) && strlen($_post['profile_custom_skin']) > 0 && $_post['profile_custom_skin'] != $_conf['jrCore_active_skin']) {
            if ($_post['profile_custom_skin'] == $_pr['quota_jrProfileTweaks_default_skin']) {
                if (isset($_pr['profile_custom_skin'])) {
                    jrCore_db_delete_item_key('jrProfile', $pid, 'profile_custom_skin');
                    jrUser_delete_session_key('profile_custom_skin');
                }
            }
            else {
                $_data['profile_custom_skin'] = $_post['profile_custom_skin'];
            }

        }
        else {
            if (!empty($_pr['quota_jrProfileTweaks_default_skin']) && $_post['profile_custom_skin'] != $_pr['quota_jrProfileTweaks_default_skin']) {
                $_data['profile_custom_skin'] = $_post['profile_custom_skin'];
            }
            else {
                jrCore_db_delete_item_key('jrProfile', $pid, 'profile_custom_skin');
                jrUser_delete_session_key('profile_custom_skin');
            }
        }
    }
    else {
        if (isset($_pr['profile_custom_skin'])) {
            jrCore_db_delete_item_key('jrProfile', $pid, 'profile_custom_skin');
            jrUser_delete_session_key('profile_custom_skin');
        }
    }

    if (count($_data) > 0) {
        jrCore_db_update_item('jrProfile', $pid, $_data);
    }

    jrProfile_reset_cache($pid);
    jrUser_reset_cache($_user['_user_id']);
    if ($own) {
        jrUser_session_sync();
    }

    jrCore_form_delete_session();
    jrCore_set_form_notice('success', 13);
    jrCore_form_result();
}
