<?php
 /**
 * Jamroom Profiles module
 *
 * copyright 2024 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: quota_clone_save
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrProfile_quota_clone_save($_post, $_user, $_conf)
{
    jrUser_master_only();
    jrCore_form_validate($_post);
    if (isset($_post['new_quota_name']) && strlen($_post['new_quota_name']) > 0) {
        $qid = jrProfile_create_quota($_post['new_quota_name']);
        if (isset($qid) && jrCore_checktype($qid, 'number_nz')) {

            // Next - we need to get all settings for
            // the quota we are cloning FROM, and add them to our new quota
            $_qt = jrProfile_get_quota($_post['clone_id']);
            foreach ($_qt as $k => $v) {
                switch ($k) {
                    // There are some keys we do not copy over
                    case 'quota_jrProfile_name':
                    case 'quota_jrProfile_profile_count':
                        continue 2;
                    default:
                        // [quota_jrAudio_allowed_audio_types]
                        list(, $module, $name) = explode('_', $k, 3);
                        jrProfile_set_quota_value($module, $qid, $name, $v);
                        break;
                }
            }
            jrCore_form_delete_session();
            jrCore_set_form_notice('success', "The new Profile Quota was successfully cloned from the {$_qt['quota_jrProfile_name']} quota");
            jrCore_form_result("{$_conf['jrCore_base_url']}/{$_post['module_url']}/quota_browser");
        }
        jrCore_set_form_notice('error', 'An error was encountered creating the Profile Quota - please try again');
    }
    else {
        jrCore_set_form_notice('error', 'Please enter a valid Profile Quota name to create a new quota');
    }
    jrCore_form_result();
}
