// @copyright 2003-2019 by Talldude Networks LLC
// @author Brian Johnson - brian@jamroom.net

function jrProduct_show_cat_fields(cat_id, prod_id)
{
    var url = core_system_url + '/' + jrProduct_url + '/get_cat_fields/' + cat_id + '/' + prod_id + '/__ajax=1';
    $.getJSON(url, function(data) {
        if (typeof data.success !== "undefined" && typeof data.success === "object") {
            $.each(data.success, function(k, v) {
                $("#cat_fields_label_" + k).html(v.label);
                $("#cat_fields_detail_" + k).html(v.detail);
            });
        }
        else if (typeof data.error !== "undefined" && typeof data.success === "object") {
            jrCore_alert(data.error);
        }
    });
}

/**
 * Save tracking info
 * @param {number} i
 * @param {number} id
 */
function jrProduct_save_tracking_info(i, id)
{
    var s = $('#tracking_id_' + i).val();
    if (s.length > 0) {
        var n = 'off';
        if ($('#tracking_notify_' + i).is(":checked")) {
            n = 'on';
        }
        setTimeout(function() {
            var u = core_system_url + '/' + jrProduct_url + '/tracking_info_save/__ajax=1';
            jrCore_set_csrf_cookie(u);
            $.ajax({
                url: u,
                type: 'POST',
                cache: false,
                data: {'r_id': Number(i), 'id': Number(id), 'tracking_info': s, notify: n},
                dataType: 'json',
                success: function(r) {
                    if (typeof r.error !== "undefined") {
                        jrCore_alert(r.error);
                    }
                    else {
                        window.location.reload();
                    }
                },
                error: function() {
                    jrCore_alert('error communicating with server - please try again');
                }
            });
        }, 500);
    }
}
