<?php
 /**
 * Jamroom Payment Support module
 *
 * copyright 2023 The Jamroom Network
 *
 * This Jamroom file is LICENSED SOFTWARE, and cannot be redistributed.
 *
 * This Source Code is subject to the terms of the Jamroom Network
 * Commercial License -  please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: update_quantity_save
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrPayment_update_quantity_save($_post, $_user, $_conf)
{
    jrUser_session_require_login();
    jrCore_validate_location_url();
    if (!isset($_post['id']) || !jrCore_checktype($_post['id'], 'number_nz')) {
        $_rs = array('error', 'invalid cart_entry_id - please try again');
        jrCore_json_response($_rs);
    }
    if (!isset($_post['qty']) || !jrCore_checktype($_post['qty'], 'number_nn')) {
        $_rs = array('error', 'invalid cart quantity - please try again');
        jrCore_json_response($_rs);
    }
    // Get user's cart
    $_cr = jrPayment_get_user_cart();
    if (!$_cr || !is_array($_cr)) {
        $_rs = array('error', 'invalid user cart - please try again');
        jrCore_json_response($_rs);
    }
    if (!isset($_cr['_items']) || !is_array($_cr['_items'])) {
        $_rs = array('error', 'no items found in cart');
        jrCore_json_response($_rs);
    }

    $eid = (int) $_post['id'];
    if (!isset($_cr['_items'][$eid])) {
        $_rs = array('error', 'invalid cart_entry_id - please try again');
        jrCore_json_response($_rs);
    }

    if ($_post['qty'] > 0) {

        // This is the requested NEW quantity
        $_cr['_items'][$eid]['cart_new_quantity'] = (int) $_post['qty'];
        $_cr['_items'][$eid]                      = jrCore_trigger_event('jrPayment', 'cart_update_quantity', $_cr['_items'][$eid], $_cr, $_cr['_items'][$eid]['cart_module']);
        $qty                                      = (int) $_cr['_items'][$eid]['cart_new_quantity'];
        if ($qty > 0) {
            if (jrPayment_update_cart_item_quantity($_cr['cart_id'], $eid, $qty)) {
                // We have successfully updated the quantity - return correct price
                $shp = ($_cr['_items'][$eid]['cart_shipping'] / $_cr['_items'][$eid]['cart_quantity']);
                $itm = ($_cr['_items'][$eid]['cart_amount'] / $_cr['_items'][$eid]['cart_quantity']);
                $_rs = array(
                    'price'    => jrPayment_currency_format($qty * $itm),
                    'shipping' => jrPayment_currency_format($qty * $shp)
                );
                if ($qty != $_post['qty']) {
                    // We had to adjust the quantity
                    $_ln             = jrUser_load_lang_strings();
                    $_rs['adjusted'] = 1;
                    $_rs['title']    = $_ln['jrPayment'][51];
                    $_rs['text']     = str_replace('%1', $qty, $_ln['jrPayment'][52]);
                }
                jrCore_json_response($_rs);
            }
        }
        else {
            // Event listener tells us there are none left
            if (jrPayment_remove_item_from_cart($_cr['cart_id'], $eid)) {
                $_ln = jrUser_load_lang_strings();
                $_rs = array(
                    'delete'   => 1,
                    'adjusted' => 1,
                    'title'    => $_ln['jrPayment'][51],
                    'text'     => str_replace('%1', 0, $_ln['jrPayment'][52])
                );
                jrCore_json_response($_rs);
            }
        }
    }
    else {
        // We are removing this item from the cart
        if (jrPayment_remove_item_from_cart($_cr['cart_id'], $eid)) {
            $_rs = array('delete' => 1);
            jrCore_json_response($_rs);
        }
    }
    $_rs = array('error', 'an error was encountered updating the cart item');
    jrCore_json_response($_rs);
}
