<?php
 /**
 * Jamroom Payment Support module
 *
 * copyright 2023 The Jamroom Network
 *
 * This Jamroom file is LICENSED SOFTWARE, and cannot be redistributed.
 *
 * This Source Code is subject to the terms of the Jamroom Network
 * Commercial License -  please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: transactions
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrPayment_transactions($_post, $_user, $_conf)
{
    global $_mods;
    jrUser_master_only();
    jrCore_page_admin_tabs('jrPayment');
    jrCore_page_include_admin_menu();

    $url = jrCore_strip_url_params(jrCore_get_current_url(), array('type', 'p', 'search_string'));
    if (empty($_post['txn_id'])) {
        $btn = '<select name="payment_type" class="form_select form_select_item_jumper" onchange="jrCore_window_location(\'' . $url . "/type='+ $(this).val())\">\n";
        if (isset($_post['type']) && $_post['type'] == 'all') {
            $btn .= "<option value=\"payments\"> balance affecting events</option>\n";
            $btn .= "<option value=\"all\" selected=\"selected\"> all events</option>\n";
        }
        else {
            $btn .= "<option value=\"payments\" selected=\"selected\"> balance affecting events</option>\n";
            $btn .= "<option value=\"all\"> all events</option>\n";
        }
        $btn .= '</select>';
    }
    else {
        $btn = null;
    }
    jrCore_page_banner('Event Browser', $btn);

    jrCore_get_form_notice();
    if (empty($_post['txn_id'])) {
        jrCore_page_search('search', $url);
    }

    // Show items
    $dat[1]['title'] = '';
    $dat[1]['width'] = '2%';
    $dat[2]['title'] = 'event';
    $dat[2]['width'] = '50%';
    $dat[3]['title'] = 'type';
    $dat[3]['width'] = '10%';
    $dat[4]['title'] = 'amount';
    $dat[4]['width'] = '10%';
    $dat[5]['title'] = 'date / ID';
    $dat[5]['width'] = '24%';
    $dat[6]['title'] = 'detail';
    $dat[6]['width'] = '4%';
    jrCore_page_table_header($dat);

    $page = 1;
    if (isset($_post['p']) && jrCore_checktype($_post['p'], 'number_nz')) {
        $page = (int) $_post['p'];
    }

    $_rt = array(
        'order_by'      => array('_item_id' => 'desc'),
        'skip_triggers' => true,
        'page'          => $page,
        'pagebreak'     => jrCore_get_pager_rows(),
        'no_cache'      => true
    );
    if (!empty($_post['txn_id'])) {
        $_ids = false;
        if (jrCore_checktype($_post['txn_id'], 'number_nz')) {
            $_ids = array(intval($_post['txn_id']));
        }
        elseif (strpos($_post['txn_id'], ',')) {
            $_ids = explode(',', $_post['txn_id']);
            $_ids = array_filter($_ids, 'is_numeric');
        }
        if (!empty($_ids)) {
            $_rt['search'] = array('_item_id in ' . implode(',', $_ids));
        }
    }
    else {
        if (isset($_post['search_string']) && strlen($_post['search_string']) > 0) {
            if (!isset($_rt['search'])) {
                $_rt['search'] = array();
            }
            $_rt['search'][] = "txn_% like %{$_post['search_string']}%";
        }
        if (!isset($_post['type']) || $_post['type'] != 'all') {
            if (!isset($_rt['search'])) {
                $_rt['search'] = array();
            }
            $_rt['search'][] = 'txn_total >= 0';
        }
    }
    $_rt = jrCore_db_search_items('jrPayment', $_rt);
    if ($_rt && is_array($_rt) && isset($_rt['_items']) && is_array($_rt['_items'])) {

        $_mt = array();
        $url = jrCore_get_base_url();
        foreach ($_rt['_items'] as $k => $_t) {

            if (!isset($_t['txn_plugin'])) {
                $_t['txn_plugin'] = jrPayment_get_active_plugin();
            }
            if (!isset($_mt["{$_t['txn_plugin']}"])) {
                $_mt["{$_t['txn_plugin']}"] = jrPayment_get_plugin_meta_data($_t['txn_plugin']);
            }
            if (!empty($_t['txn_category'])) {
                $dat[1]['title'] = "<img src=\"{$url}/modules/jrPayment/icon.png?v={$_mods['jrPayment']['module_version']}\" width=\"40\" height=\"40\" alt=\"system\">";
                $dat[2]['title'] = "payment support<br><small>manual transaction</small>";
            }
            else {
                $dat[1]['title'] = "<img src=\"{$url}/modules/jrPayment/img/{$_t['txn_plugin']}.png?v={$_mt["{$_t['txn_plugin']}"]['version']}\" width=\"40\" height=\"40\" alt=\"system\">";
                $dat[2]['title'] = ucwords($_t['txn_plugin']) . '<br>';
            }
            if (isset($_t['txn_raw'])) {
                $_t['txn_raw'] = json_decode($_t['txn_raw'], true);
            }
            jrPayment_set_active_plugin($_t['txn_plugin']);
            if ($title = jrPayment_run_plugin_function('webhook_transaction_title', $_t)) {
                $dat[2]['title'] .= '<small>' . $title . '</small>';
            }
            jrPayment_set_active_plugin($_conf['jrPayment_plugin']);

            $cur = jrPayment_get_currency_code();
            if (isset($_t['txn_currency'])) {
                $cur = jrPayment_get_currency_entity($_t['txn_currency']);
            }

            $dat[3]['title'] = $_t['txn_type'];
            $dat[3]['class'] = 'center';
            $dat[4]['title'] = (!empty($_t['txn_total'])) ? $cur . jrPayment_currency_format($_t['txn_total']) : '-';
            $dat[4]['class'] = 'center';
            $dat[5]['title'] = jrCore_format_time($_t['_created']);
            if (isset($_t['txn_id']) && strlen($_t['txn_id']) > 0) {
                $dat[5]['title'] .= '<br><small>' . $_t['txn_id'] . '</small>';
            }
            $dat[5]['class'] = 'center';
            $dat[6]['title'] = jrCore_page_button("txn-detail-{$k}", 'detail', "jrCore_window_location('{$url}/{$_post['module_url']}/txn_detail/{$_t['_item_id']}')");
            $dat[6]['class'] = 'center';

            $dat = jrCore_trigger_event('jrPayment', 'txn_entry', $dat, $_t);
            jrCore_page_table_row($dat);
        }
        jrCore_page_table_pager($_rt);
    }
    else {
        $dat             = array();
        $dat[1]['title'] = 'no transactions have been recorded yet';
        $dat[1]['class'] = 'center p10';
        jrCore_page_table_row($dat);
    }
    jrCore_page_table_footer();
    jrCore_page_cancel_button('referrer');
    jrCore_page_display();
}
