<?php
 /**
 * Jamroom Payment Support module
 *
 * copyright 2023 The Jamroom Network
 *
 * This Jamroom file is LICENSED SOFTWARE, and cannot be redistributed.
 *
 * This Source Code is subject to the terms of the Jamroom Network
 * Commercial License -  please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: transaction
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrPayment_transaction($_post, $_user, $_conf)
{
    jrUser_session_require_login();
    if (!isset($_post['_1']) || !jrCore_checktype($_post['_1'], 'number_nz')) {
        jrCore_set_form_notice('error', 'invalid transaction id');
        jrCore_location('referrer');
    }
    if (!$_tr = jrPayment_get_transaction_by_id($_post['_1'])) {
        jrCore_set_form_notice('error', 'invalid transaction id');
        jrCore_location('referrer');
    }
    if (!jrUser_is_admin() && $_tr['r_seller_profile_id'] != $_user['user_active_profile_id']) {
        jrUser_not_authorized();
    }
    $_ln = jrUser_load_lang_strings();

    jrCore_page_banner(22);
    jrCore_get_form_notice();

    $dat             = array();
    $dat[1]['title'] = $_ln['jrPayment'][38];
    $dat[1]['width'] = '20%';
    $dat[2]['title'] = $_ln['jrPayment'][39];
    $dat[2]['width'] = '80%';
    jrCore_page_table_header($dat);

    foreach ($_tr as $k => $v) {
        if (strpos($k, '_') !== 0) {
            switch ($k) {
                case 'txn_raw':
                case 'txn_plugin':
                case 'txn_pos_payment':
                case 'txn_user_id':
                case 'txn_cart_id':
                case 'txn_cart_hash':
                case 'txn_gateway_fee':
                    break;
                default:
                    if (!jrUser_is_admin() && strpos(' ' . $k, 'email')) {
                        continue 2;
                    }
                    $dat[1]['title'] = $k;
                    if ((strpos($k, 'date') || strpos($k, 'time')) && jrCore_checktype($v, 'number_nz')) {
                        $dat[2]['title'] = jrCore_format_time($v);
                    }
                    elseif ((strpos($k, 'charge') || strpos($k, 'total') || strpos($k, 'shipping') || strpos($k, 'tax')) && jrCore_checktype($v, 'number_nz')) {
                        $dat[2]['title'] = jrPayment_currency_format($v);
                    }
                    else {
                        $dat[2]['title'] = $v;
                    }
                    jrCore_page_table_row($dat);
            }
        }
    }
    jrCore_page_table_footer();
    jrCore_page_cancel_button('referrer');
    jrCore_page_display();
}
