<?php
 /**
 * Jamroom Payment Support module
 *
 * copyright 2023 The Jamroom Network
 *
 * This Jamroom file is LICENSED SOFTWARE, and cannot be redistributed.
 *
 * This Source Code is subject to the terms of the Jamroom Network
 * Commercial License -  please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: success
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrPayment_success($_post, $_user, $_conf)
{
    // NOTE: Our cart doesn't actually "clear" until the webhook from the payment
    // processor comes through - but if we hit here it means we've just made payment
    // and we can "clear" the cart (even though it remains)
    if ($_cr = jrPayment_get_user_cart(false)) {
        // "1" marks this cart as COMPLETE
        jrPayment_set_cart_status($_cr['cart_id'], PAYMENT_CART_COMPLETE);
    }

    jrCore_trigger_event('jrPayment', 'payment_success_page', $_post);
    $_ln = jrUser_load_lang_strings();
    jrCore_page_notice('success', "<div class=\"p10 center\">{$_ln['jrPayment'][28]}<br><br>{$_ln['jrPayment'][30]}</div>", false);
    jrCore_page_cancel_button("{$_conf['jrCore_base_url']}/{$_post['module_url']}/purchases", $_ln['jrPayment'][29]);
    jrCore_page_display();
}
