<?php
 /**
 * Jamroom Payment Support module
 *
 * copyright 2023 The Jamroom Network
 *
 * This Jamroom file is LICENSED SOFTWARE, and cannot be redistributed.
 *
 * This Source Code is subject to the terms of the Jamroom Network
 * Commercial License -  please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: report_detail
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrPayment_report_detail($_post, $_user, $_conf)
{
    global $_mods;
    jrUser_master_only();
    jrCore_page_admin_tabs('jrPayment');
    jrCore_page_include_admin_menu();

    $date = date('Ym');
    $time = time();
    $frmt = '%Y%m';
    if (isset($_post['date'])) {
        if (strlen($_post['date']) === 6) {
            $date = $_post['date'];
            $time = gmmktime(1, 1, 1, substr($date, 4, 2), 15, substr($date, 0, 4));
        }
        elseif (strlen($_post['date']) === 4) {
            $date = $_post['date'];
            $time = gmmktime(1, 1, 1, 1, 15, substr($date, 0, 4));
            $frmt = '%Y';
        }
    }
    $button = jrCore_page_button('back', 'monthly report', "jrCore_window_location('{$_conf['jrCore_base_url']}/{$_post['module_url']}/report')");
    jrCore_page_banner("monthly report - " . date('F, Y', $time), $button);

    $_rt = array();
    $off = date_offset_get(new DateTime);
    $tbl = jrCore_db_table_name('jrPayment', 'register');
    $req = "SELECT r_seller_profile_id AS p,
              SUM(((r_quantity * r_amount) + r_shipping + r_tax) - r_refunded_amount) AS i,
              SUM(r_fee) AS e,
              SUM(r_gateway_fee) AS f,
              SUM(r_expense) AS s,
              IF(r_field = 'transaction', r_tag, r_module) AS m
            FROM {$tbl} WHERE FROM_UNIXTIME(r_created + {$off}, '{$frmt}') = '{$date}' GROUP BY m, p ORDER BY i DESC, s DESC";
    $_tm = jrCore_db_query($req, 'NUMERIC');

    // Get our totals
    $inc = 0;
    $exp = 0;
    $fee = 0;
    if ($_tm && is_array($_tm)) {
        foreach ($_tm as $v) {
            $idx = $v['m'];
            if (!isset($_rt[$idx])) {
                $_rt[$idx] = array(
                    'i' => 0,
                    'e' => 0,
                    'f' => 0,
                    's' => 0,
                    'm' => $idx
                );
            }
            $_rt[$idx]['i'] += $v['i'];
            $_rt[$idx]['f'] += $v['f'];
            if ($v['p'] > 0) {
                $_rt[$idx]['e'] += ($v['e'] + $v['s']);
                $exp            += ($v['e'] + $v['s']);
            }
            else {
                $_rt[$idx]['e'] += $v['s'];
                $exp            += $v['s'];
            }
            $inc += $v['i'];
            $fee += $v['f'];
        }
    }
    unset($_tm);

    $dat             = array();
    $dat[1]['title'] = 'gross income';
    $dat[1]['width'] = '25%';
    $dat[2]['title'] = 'expense';
    $dat[2]['width'] = '25%';
    $dat[3]['title'] = 'gateway fees';
    $dat[3]['width'] = '25%';
    $dat[4]['title'] = 'net income';
    $dat[4]['width'] = '25%';
    jrCore_page_table_header($dat);

    $dat             = array();
    $dat[1]['title'] = jrPayment_get_currency_code() . jrPayment_currency_format($inc);
    $dat[1]['class'] = 'payment-bignum bignum bignum4';
    $dat[2]['title'] = jrPayment_get_currency_code() . jrPayment_currency_format($exp);
    $dat[2]['class'] = 'payment-bignum bignum bignum1';
    $dat[3]['title'] = jrPayment_get_currency_code() . jrPayment_currency_format($fee);
    $dat[3]['class'] = 'payment-bignum bignum bignum1';
    $dat[4]['title'] = jrPayment_get_currency_code() . jrPayment_currency_format($inc - $exp - $fee);
    $dat[4]['class'] = 'payment-bignum bignum bignum3';
    jrCore_page_table_row($dat);
    jrCore_page_table_footer();

    if (!empty($_rt)) {
        $dat             = array();
        $dat[0]['title'] = 'category';
        $dat[0]['width'] = '28%';
        $dat[1]['title'] = 'gross';
        $dat[1]['width'] = '18%';
        $dat[2]['title'] = 'expense';
        $dat[2]['width'] = '18%';
        $dat[3]['title'] = 'gateway fees';
        $dat[3]['width'] = '18%';
        $dat[4]['title'] = 'income';
        $dat[4]['width'] = '18%';
        jrCore_page_table_header($dat);

        foreach ($_rt as $v) {
            if (isset($_mods["{$v['m']}"])) {
                $dat[0]['title'] = ucwords($_mods["{$v['m']}"]['module_name']);
            }
            else {
                $dat[0]['title'] = ucwords($v['m']);
            }
            $dat[0]['class'] = 'center';
            $dat[1]['title'] = jrPayment_get_currency_code() . jrPayment_currency_format($v['i']);
            $dat[1]['class'] = 'center';
            $dat[2]['title'] = jrPayment_get_currency_code() . jrPayment_currency_format($v['e']);
            $dat[2]['class'] = 'center';
            $dat[3]['title'] = jrPayment_get_currency_code() . jrPayment_currency_format($v['f']);
            $dat[3]['class'] = 'center';

            $total           = ($v['i'] - $v['e'] - $v['f']);
            $dat[4]['title'] = jrPayment_get_currency_code() . jrPayment_currency_format($total);
            if ($total > 0) {
                $dat[4]['class'] = 'center success';
            }
            elseif (intval($total) === 0) {
                $dat[4]['class'] = 'center';
            }
            else {
                $dat[4]['class'] = 'center error';
            }
            jrCore_page_table_row($dat);
        }
        jrCore_page_table_footer();
    }
    jrCore_page_cancel_button('referrer');
    jrCore_page_display();
}
