<?php
 /**
 * Jamroom Payment Support module
 *
 * copyright 2023 The Jamroom Network
 *
 * This Jamroom file is LICENSED SOFTWARE, and cannot be redistributed.
 *
 * This Source Code is subject to the terms of the Jamroom Network
 * Commercial License -  please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: purchases
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrPayment_purchases($_post, $_user, $_conf)
{
    jrUser_session_require_login();

    $_data = jrUser_get_requested_user_account_info();
    jrUser_account_tabs('purchases', $_data);
    $uid = (int) $_data['_user_id'];

    // Get language strings
    $_ln = jrUser_load_lang_strings();

    $button = '';
    // List all items
    if (isset($_post['item']) && strpos($_post['item'], ':')) {
        if (jrUser_is_admin() && isset($_post['user_id']) && jrCore_checktype($_post['user_id'], 'number_nz')) {
            $button .= jrCore_page_button('all-purchases', $_ln['jrPayment'][55], "jrCore_window_location('{$_conf['jrCore_base_url']}/{$_post['module_url']}/purchases/user_id={$_post['user_id']}')");
        }
        else {
            $button .= jrCore_page_button('all-purchases', $_ln['jrPayment'][55], "jrCore_window_location('{$_conf['jrCore_base_url']}/{$_post['module_url']}/purchases')");
        }
    }
    if (!empty($_data['profile_name'])) {
        $button = jrCore_page_button('account-tabs-profile-button', "@{$_data['profile_url']}", "jrCore_window_location('{$_conf['jrCore_base_url']}/{$_data['profile_url']}')");
    }
    jrCore_page_banner(15, $button);
    jrCore_get_form_notice();

    // get all purchases for this user
    $tbl = jrCore_db_table_name('jrPayment', 'register');
    if (isset($_post['item']) && strpos($_post['item'], ':')) {
        list($mod, $iid) = explode(':', $_post['item']);
        $iid = (int) $iid;
        $req = "SELECT * FROM {$tbl} WHERE r_purchase_user_id = {$uid} AND r_field != 'transaction' AND r_hidden = 0 AND r_module = '" . jrCore_db_escape($mod) . "' AND r_item_id = {$iid} ORDER BY r_created DESC";
    }
    else {
        $req = "SELECT * FROM {$tbl} WHERE r_purchase_user_id = {$uid} AND r_field != 'transaction' AND r_hidden = 0 ORDER BY r_created DESC";
    }
    $page = 1;
    if (isset($_post['p']) && jrCore_checktype($_post['p'], 'number_nz')) {
        $page = (int) $_post['p'];
    }
    $_rt = jrCore_db_paged_query($req, $page, 12);

    // Show items
    if (jrUser_is_admin()) {
        $dat[0]['title'] = '<input type="checkbox" class="form_checkbox" onclick="$(\'.register-checkbox\').prop(\'checked\',$(this).prop(\'checked\'));">';
        $dat[0]['width'] = '1%';
        $dat[1]['title'] = '';
        $dat[1]['width'] = '1%';
    }
    else {
        $dat[1]['title'] = '';
        $dat[1]['width'] = '2%';
    }
    $dat[2]['title'] = $_ln['jrPayment'][7];
    $dat[2]['width'] = '68%';
    $dat[3]['title'] = $_ln['jrPayment'][16];
    $dat[3]['width'] = '15%';
    $dat[4]['title'] = $_ln['jrPayment'][9];
    $dat[4]['width'] = '10%';
    $dat[5]['title'] = $_ln['jrPayment'][36];
    $dat[5]['width'] = '5%';
    if (jrUser_is_admin()) {
        $dat[6]['title'] = 'admin';
        $dat[6]['width'] = '5%';
        $dat[2]['width'] = '62%';
    }
    jrCore_page_table_header($dat);

    if ($_rt && is_array($_rt) && isset($_rt['_items']) && is_array($_rt['_items'])) {

        $_rt['_items'] = jrPayment_get_data_for_items($_rt['_items']);

        foreach ($_rt['_items'] as $k => $_r) {
            $dat = array();

            $_it = $_r['r_item_data'];
            if (jrCore_checktype($_it, 'json')) {
                $_it = json_decode($_it, true);
            }

            if (jrUser_is_admin()) {
                $dat[0]['title'] = '<input type="checkbox" class="form_checkbox register-checkbox" name="' . $_r['r_id'] . '">';
                $dat[0]['class'] = 'center';
            }

            if (jrCore_is_datastore_module($_r['r_module'])) {
                $pfx             = jrCore_db_get_prefix($_r['r_module']);
                $_im             = array(
                    'crop'   => 'auto',
                    'alt'    => $_it["{$pfx}_title"],
                    'title'  => $_it["{$pfx}_title"],
                    'width'  => 48,
                    'height' => 48,
                    '_v'     => (isset($_it["{$pfx}_image_time"]) && $_it["{$pfx}_image_time"] > 0) ? $_it["{$pfx}_image_time"] : $_r['r_created']
                );
                $dat[1]['title'] = jrImage_get_image_src($_r['r_module'], "{$pfx}_image", $_r['r_item_id'], 'small', $_im);
            }
            else {
                $pfx             = false;
                $dat[1]['title'] = jrCore_get_module_icon_html($_r['r_module'], 48);
            }

            if (isset($_it['profile_url'])) {
                $url             = "{$_conf['jrCore_base_url']}/{$_it['profile_url']}/" . jrCore_get_module_url($_r['r_module']) . "/{$_it['_item_id']}/{$_it["{$pfx}_title_url"]}";
                $dat[2]['title'] = '<h3><a href="' . $_conf['jrCore_base_url'] . '/' . $_it['profile_url'] . '" style="text-transform:none">@' . $_it['profile_url'] . '</a> - <a href="' . $url . '">' . $_it["{$pfx}_title"] . "</a></h3><br><small>{$_ln['jrPayment'][8]}: {$_r['r_quantity']}</small>";
            }
            else {
                $dat[2]['title'] = '<h3>' . $_it["{$pfx}_title"] . "</h3><br><small>{$_ln['jrPayment'][8]}: {$_r['r_quantity']}</small>";
            }
            $dat[3]['title'] = jrCore_format_time($_r['r_created']);
            $dat[3]['class'] = 'center';
            if ($_r['r_refunded_time'] > 0) {
                $dat[4]['title'] = '<strike>' . jrPayment_get_currency_entity($_r['r_currency']) . jrPayment_currency_format($_r['r_amount']) . '</strike>';
                $dat[4]['title'] .= '<br><b><small>' . $_ln['jrPayment'][34] . '</small></b>';
                $dat[5]['title'] = jrCore_page_button("r-download-{$k}", $_ln['jrPayment'][37], 'disabled');
            }
            else {
                $dat[4]['title'] = jrPayment_get_currency_entity($_r['r_currency']) . jrPayment_currency_format($_r['r_amount'] * $_r['r_quantity']);
                if ($_r['r_shipping'] > 0) {
                    $dat[4]['title'] .= '<br><small>+' . jrPayment_get_currency_entity($_r['r_currency']) . jrPayment_currency_format($_r['r_shipping'] * $_r['r_quantity']) . " {$_ln['jrPayment'][10]}</small>";
                }
                $dat[5]['title'] = jrCore_page_button("r-download-{$k}", $_ln['jrPayment'][37], "jrCore_window_location('{$_conf['jrCore_base_url']}/{$_post['module_url']}/download/{$_r['r_id']}')");
            }
            $dat[4]['class'] = 'center';
            $dat[5]['class'] = 'center';
            if (jrUser_is_admin()) {
                if ($_r['r_refunded_time'] > 0) {
                    $dat[6]['title'] = jrCore_page_button("r-refunded-{$k}", 'refunded', 'disabled');
                }
                else {
                    $dat[6]['title'] = jrCore_page_button("r-refunded-{$k}", 'refunded', "jrCore_confirm('Mark as Refunded?','Mark this entry as refunded and block download?', function() { jrCore_window_location('{$_conf['jrCore_base_url']}/{$_post['module_url']}/refund_register_id/{$_r['r_id']}') })");
                }
                $dat[6]['class'] = 'center';
            }

            // Trigger so individual modules can customize their row if needed
            $dat = jrCore_trigger_event('jrPayment', 'purchase_entry', $dat, $_r, $_r['r_module']);
            if ($dat && is_array($dat) && count($dat) > 0) {
                jrCore_page_table_row($dat);
            }

        }
        if (jrUser_is_admin()) {
            $sjs             = "var v = $('input:checkbox.register-checkbox:checked').map(function(){ return this.name; }).get().join(',')";
            $tmp             = jrCore_page_button("delete", 'delete checked', "jrCore_confirm('Delete Purchases?','The deleted items will be removed and can no longer be downloaded.',function() { {$sjs};jrCore_window_location('{$_conf['jrCore_base_url']}/{$_post['module_url']}/register_entry_delete/id='+ v )} )");
            $dat             = array();
            $dat[1]['title'] = $tmp;
            jrCore_page_table_row($dat);
        }
        jrCore_page_table_pager($_rt);
    }
    else {
        $dat             = array();
        $dat[1]['title'] = $_ln['jrPayment'][18];
        $dat[1]['class'] = 'center p20';
        jrCore_page_table_row($dat);
    }
    jrCore_page_table_footer();
    jrCore_page_display();
}
