<?php
 /**
 * Jamroom Payment Support module
 *
 * copyright 2023 The Jamroom Network
 *
 * This Jamroom file is LICENSED SOFTWARE, and cannot be redistributed.
 *
 * This Source Code is subject to the terms of the Jamroom Network
 * Commercial License -  please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: plugin_config_save
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrPayment_plugin_config_save($_post, $_user, $_conf)
{
    jrUser_master_only();
    jrCore_form_validate($_post);
    if (!isset($_post['plugin']) || !jrPayment_is_valid_plugin($_post['plugin'])) {
        jrCore_set_form_notice('error', 'invalid plugin');
        jrCore_form_result();
    }
    // Is our plugin doing any validation?
    $plug = $_post['plugin'];
    $func = "jrPayment_plugin_{$plug}_config_validate";
    if (!function_exists($func)) {
        require_once APP_DIR . "/modules/jrPayment/plugins/{$plug}.php";
    }
    if (function_exists($func)) {
        if (!$func($_post)) {
            jrCore_form_result();
        }
    }
    // Some things we don't save
    $_data = $_post;
    unset($_data['module'], $_data['module_url'], $_data['option'], $_data['uri'], $_data['_1'], $_data['_2']);

    $plg = jrCore_db_escape($plug);
    $_cf = jrCore_db_escape(json_encode($_data));
    $tbl = jrCore_db_table_name('jrPayment', 'plugin_config');
    $req = "INSERT INTO {$tbl} (config_plugin, config_time, config_content) VALUES ('{$plg}', UNIX_TIMESTAMP(), '{$_cf}') ON DUPLICATE KEY UPDATE config_time = UNIX_TIMESTAMP(), config_content = '{$_cf}'";
    $cnt = jrCore_db_query($req, 'COUNT');
    if ($cnt && $cnt == 0) {
        jrCore_set_form_notice('error', 'an error was encountered saving the config - please try again');
        jrCore_form_result();
    }
    jrCore_set_form_notice('success', 'The config settings were successfully saved');
    jrCore_form_result();
}
