<?php
 /**
 * Jamroom Payment Support module
 *
 * copyright 2023 The Jamroom Network
 *
 * This Jamroom file is LICENSED SOFTWARE, and cannot be redistributed.
 *
 * This Source Code is subject to the terms of the Jamroom Network
 * Commercial License -  please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: plugin_browser
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrPayment_plugin_browser($_post, $_user, $_conf)
{
    jrUser_master_only();
    jrCore_page_admin_tabs('jrPayment');
    jrCore_page_include_admin_menu();
    jrCore_page_banner('Payment Processor Plugins');
    jrCore_get_form_notice();

    $dat             = array();
    $dat[1]['title'] = 'icon';
    $dat[1]['width'] = '1%';
    $dat[2]['title'] = 'payment processor';
    $dat[2]['width'] = '87%';
    $dat[3]['title'] = 'active';
    $dat[3]['width'] = '8%';
    $dat[4]['title'] = 'settings';
    $dat[4]['width'] = '4%';
    jrCore_page_table_header($dat);

    $_pl = jrPayment_get_plugins();
    $act = jrCore_get_option_image('pass');
    $ina = jrCore_get_option_image('fail');
    $url = jrCore_get_module_url('jrImage');
    foreach ($_pl as $plug => $title) {
        $_mt             = jrPayment_get_plugin_meta_data($plug);
        $dat             = array();
        $dat[1]['title'] = "<img src=\"{$_conf['jrCore_base_url']}/{$url}/img/module/jrPayment/{$plug}.png?v={$_mt['version']}\" width=\"72\" height=\"72\" title=\"{$title}\" alt=\"{$plug}\">";
        $dat[1]['class'] = 'p10 center';
        $dat[2]['title'] = '<h2>' . $title . '</h2>';
        if (isset($_mt['description'])) {
            $dat[2]['title'] .= '<br>' . $_mt['description'];
        }
        if (isset($_mt['url'])) {
            $dat[2]['title'] .= '<br><a href="' . $_mt['url'] . '" target="_blank">' . $_mt['url'] . '</a>';
        }

        $dat[2]['class'] = 'p10';
        if (isset($_conf['jrPayment_plugin']) && $_conf['jrPayment_plugin'] == $plug) {
            $dat[3]['title'] = $act;
        }
        elseif ($plug == 'paypal' && isset($_conf['jrPayment_show_paypal']) && $_conf['jrPayment_show_paypal'] == 'on') {
            $dat[3]['title'] = $act;
        }
        else {
            $dat[3]['title'] = $ina;
        }
        $dat[3]['class'] = 'center';
        $dat[4]['title'] = jrCore_page_button("c{$plug}", 'settings', "jrCore_window_location('{$_conf['jrCore_base_url']}/{$_post['module_url']}/plugin_config/{$plug}')");
        $dat[4]['class'] = 'p10';
        jrCore_page_table_row($dat);
    }
    jrCore_page_table_footer();
    jrCore_page_cancel_button('referrer');
    jrCore_page_display();
}
