<?php
 /**
 * Jamroom Payment Support module
 *
 * copyright 2023 The Jamroom Network
 *
 * This Jamroom file is LICENSED SOFTWARE, and cannot be redistributed.
 *
 * This Source Code is subject to the terms of the Jamroom Network
 * Commercial License -  please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: payout_csv
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrPayment_payout_csv($_post, $_user, $_conf)
{
    jrUser_master_only();
    if (!isset($_post['p_code']) || !jrCore_checktype($_post['p_code'], 'md5')) {
        jrCore_notice('error', 'invalid payout code received');
    }
    $tbl = jrCore_db_table_name('jrPayment', 'payout');
    $req = "SELECT * FROM {$tbl} WHERE payout_key = '" . jrCore_db_escape($_post['p_code']) . "'";
    $_id = jrCore_db_query($req, 'SINGLE');
    if (!$_id || !is_array($_id)) {
        jrCore_notice('error', 'invalid payout code received (2)');
    }

    // Get profiles we are paying out
    $_pp = array_flip(explode(',', $_id['payout_profile_ids']));

    // Get our payout options
    $_op = json_decode($_id['payout_options'], true);
    if (!isset($_op['pids']) || !is_array($_op['pids'])) {
        jrCore_notice('error', 'invalid payout options received');
    }

    $_pa = array();
    $tbl = jrCore_db_table_name('jrPayment', 'register');
    foreach ($_op['pids'] as $quota_id => $_pids) {

        if (!isset($_op['opts'][$quota_id])) {
            jrCore_notice('error', 'unable to retrieve quota options for quota_id ' . $quota_id);
        }

        $_opts = $_op['opts'][$quota_id];
        // We are including BOTH shipping and tax in this payout
        if ($_opts['tax'] == 'on' && $_opts['shp'] == 'on') {
            $req = "SELECT r_id, r_seller_profile_id, ((r_amount + r_shipping + r_tax) - r_fee - r_refunded_amount) AS amount FROM {$tbl}
                     WHERE r_seller_profile_id IN(" . implode(',', $_pids) . ') AND r_id IN(' . trim(trim($_id['payout_ids'], ',')) . ')';
        }
        // We are including ONLY tax in this payout
        elseif ($_opts['tax'] == 'on') {
            $req = "SELECT r_id, r_seller_profile_id, ((r_amount + r_tax) - r_fee - r_refunded_amount) AS amount FROM {$tbl}
                     WHERE r_seller_profile_id IN(" . implode(',', $_pids) . ') AND r_id IN(' . trim(trim($_id['payout_ids'], ',')) . ')';
        }
        // We are including ONLY shipping in this payout
        elseif ($_opts['shp'] == 'on') {
            $req = "SELECT r_id, r_seller_profile_id, ((r_amount + r_shipping) - r_fee - r_refunded_amount) AS amount FROM {$tbl}
                     WHERE r_seller_profile_id IN(" . implode(',', $_pids) . ') AND r_id IN(' . trim(trim($_id['payout_ids'], ',')) . ')';
        }
        // We are not including Tax OR Shipping
        else {
            $req = "SELECT r_id, r_seller_profile_id, (r_amount - r_fee - r_refunded_amount) AS amount FROM {$tbl}
                     WHERE r_seller_profile_id IN(" . implode(',', $_pids) . ') AND r_id IN(' . trim(trim($_id['payout_ids'], ',')) . ')';
        }
        $_rt = jrCore_db_query($req, 'r_id');
        if (!$_rt || !is_array($_rt)) {
            // Something is wrong...
            jrCore_notice('error', 'payout transactions listed in payout are not found in the DB');
        }
        foreach ($_rt as $_r) {
            $pid = (int) $_r['r_seller_profile_id'];
            if (isset($_pp[$pid])) {
                // This is a transaction for a profile we are paying out
                if (!isset($_pa[$pid])) {
                    $_pa[$pid] = 0;
                }
                $_pa[$pid] += $_r['amount'];
            }
        }
    }
    if (count($_pa) === 0) {
        // Something is wrong...
        jrCore_notice('error', 'no profiles found with payout balances');
    }
    if (strlen($_id['payout_refunds']) > 0) {
        // We have some refunds to process
        if ($_rf = json_decode($_id['payout_refunds'], true)) {
            foreach ($_rf as $pid => $amount) {
                if (isset($_pa[$pid])) {
                    if ($amount > $_pa[$pid]) {
                        // This profile gets no payout
                        $_pa[$pid] = 0;
                    }
                    else {
                        $_pa[$pid] = ($_pa[$pid] - $amount);
                    }
                }
            }
        }
    }

    // Get payout email addresses
    $_pr = jrCore_db_get_multiple_items('jrProfile', array_keys($_pa), array('_profile_id', 'profile_jrPayment_payout_email'));
    if (!$_pr || !is_array($_pr)) {
        jrCore_notice('error', 'unable to retrieve profile info for payout profiles');
    }
    $_pi = array();
    foreach ($_pr as $_p) {
        $pid       = (int) $_p['_profile_id'];
        $_pi[$pid] = $_p['profile_jrPayment_payout_email'];
    }

    // Format is for PayPal MassPay - use Store Currency value
    $cfg = jrPayment_get_plugin_config('paypal');
    $cur = (isset($cfg['currency']) && strlen($cfg['currency']) > 0) ? $cfg['currency'] : 'USD';

    // Format...
    $out = '';
    foreach ($_pa as $pid => $amount) {
        $out .= $_pi[$pid] . ',' . jrPayment_currency_format($amount) . ",{$cur}\n";
    }

    // Looks good - send file
    header("Cache-Control: no-store, no-cache, must-revalidate");
    header("Cache-Control: post-check=0, pre-check=0", false);
    header("Cache-Control: private");
    header("Pragma: no-cache");
    header("Content-type: application/csv");
    header("Content-Disposition: inline; filename=\"Payout_{$_post['p_code']}.csv\"");
    header("Content-length: " . strlen($out));
    ob_start();
    echo $out;
    ob_end_flush();
    exit;
}
