<?php
 /**
 * Jamroom Payment Support module
 *
 * copyright 2023 The Jamroom Network
 *
 * This Jamroom file is LICENSED SOFTWARE, and cannot be redistributed.
 *
 * This Source Code is subject to the terms of the Jamroom Network
 * Commercial License -  please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: payments
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrPayment_payments($_post, $_user, $_conf)
{
    global $_mods;
    jrUser_master_only();
    jrCore_page_admin_tabs('jrPayment', 'payments');
    jrCore_page_include_admin_menu();

    $button = jrCore_page_button('new', 'create payment', "jrCore_window_location('{$_conf['jrCore_base_url']}/{$_post['module_url']}/create_register_entry')");
    $button .= jrCore_page_button('all', 'event browser', "jrCore_window_location('{$_conf['jrCore_base_url']}/{$_post['module_url']}/transactions/type=all')");
    jrCore_page_banner('Payment Browser', $button);
    jrCore_get_form_notice();
    jrCore_page_search('search', jrCore_get_current_url());

    // get all purchases
    $tbl = jrCore_db_table_name('jrPayment', 'register');
    if (isset($_post['search_string']) && strlen($_post['search_string']) > 0) {

        // Search for attached user/profile names as well
        $sst = jrCore_db_escape($_post['search_string']);
        $_us = array(
            'search'              => array(
                "user_name like %{$_post['search_string']}%"
            ),
            'skip_triggers'       => true,
            'ignore_pending'      => false,
            'privacy_check'       => false,
            'quota_check'         => false,
            'return_item_id_only' => true,
            'limit'               => 500
        );
        $_us = jrCore_db_search_items('jrUser', $_us);
        if ($_us && is_array($_us)) {
            $ids = implode(',', $_us);
            $req = "SELECT * FROM {$tbl} WHERE (r_module LIKE '%{$sst}%' OR r_field LIKE '%{$sst}%' OR r_gateway_id LIKE '%{$sst}%' OR r_item_data LIKE '%{$sst}%' OR r_purchase_user_id IN({$ids})) ORDER BY r_created DESC";
        }
        else {
            $req = "SELECT * FROM {$tbl} WHERE (r_module LIKE '%{$sst}%' OR r_field LIKE '%{$sst}%' OR r_gateway_id LIKE '%{$sst}%' OR r_item_data LIKE '%{$sst}%') ORDER BY r_created DESC";
        }
    }
    else {
        $_ad = array();
        if (isset($_post['profile_id']) && jrCore_checktype($_post['profile_id'], 'number_nz')) {
            $_ad[] = 'r_seller_profile_id = ' . intval($_post['profile_id']);
        }
        if (isset($_post['user_id']) && jrCore_checktype($_post['user_id'], 'number_nz')) {
            $_ad[] = 'r_purchase_user_id = ' . intval($_post['user_id']);
        }
        if (isset($_post['refunded']) && $_post['refunded'] == '1') {
            $_ad[] = 'r_refunded_time > 0';
        }
        if (count($_ad) > 0) {
            $req = "SELECT * FROM {$tbl} WHERE (" . implode(' AND ', $_ad) . ") ORDER BY r_created DESC";
        }
        else {
            $req = "SELECT * FROM {$tbl} ORDER BY r_created DESC";
        }
    }
    $page = 1;
    if (isset($_post['p']) && jrCore_checktype($_post['p'], 'number_nz')) {
        $page = (int) $_post['p'];
    }
    $_rt = jrCore_db_paged_query($req, $page, 12, 'NUMERIC', 'simplepagebreak');

    // Show items
    $dat[1]['title'] = '';
    $dat[1]['width'] = '2%';
    $dat[2]['title'] = 'item';
    $dat[2]['width'] = '40%';
    $dat[3]['title'] = 'user';
    $dat[3]['width'] = '25%';
    $dat[4]['title'] = 'amount';
    $dat[4]['width'] = '10%';
    $dat[5]['title'] = 'date / TXN';
    $dat[5]['width'] = '20%';
    $dat[6]['title'] = 'detail';
    $dat[6]['width'] = '3%';
    jrCore_page_table_header($dat);

    if ($_rt && is_array($_rt) && isset($_rt['_items'])) {

        $_id = array();
        foreach ($_rt['_items'] as $_r) {
            if (isset($_r['r_purchase_user_id']) && jrCore_checktype($_r['r_purchase_user_id'], 'number_nz')) {
                $uid       = (int) $_r['r_purchase_user_id'];
                $_id[$uid] = $uid;
            }
        }
        if (count($_id) > 0) {
            $_ui = array(
                'search'                       => array('_item_id in ' . implode(',', $_id)),
                'return_keys'                  => array('_item_id', '_user_id', 'user_name', 'user_email', 'user_image_time', 'profile_url', 'profile_image_time'),
                'include_jrProfile_keys'       => true,
                'exclude_jrProfile_quota_keys' => true,
                'ignore_pending'               => true,
                'privacy_check'                => false,
                'limit'                        => count($_id)
            );
            $_ui = jrCore_db_search_items('jrUser', $_ui);
            if ($_ui && is_array($_ui) && isset($_ui['_items'])) {
                $_id = array();
                foreach ($_ui['_items'] as $_u) {
                    $uid       = (int) $_u['_user_id'];
                    $_id[$uid] = $_u;
                }
            }
        }
        unset($_ui);

        $_rt['_items'] = jrPayment_get_data_for_items($_rt['_items']);
        foreach ($_rt['_items'] as $k => $_r) {

            $pfx = jrCore_db_get_prefix($_r['r_module']);
            $_it = $_r['r_item_data'];
            if (isset($_it['profile_url']) && jrCore_is_datastore_module($_r['r_module'])) {
                $ttl         = (isset($_it["{$pfx}_title"])) ? $_it["{$pfx}_title"] : '(unknown)';
                $_im         = array(
                    'crop'   => 'auto',
                    'alt'    => $ttl,
                    'title'  => $ttl,
                    'width'  => 48,
                    'height' => 48,
                    'class'  => 'module_icon payment-icon',
                    '_v'     => (isset($_r['r_item_data']["{$pfx}_image_time"]) && $_r['r_item_data']["{$pfx}_image_time"] > 0) ? $_r['r_item_data']["{$pfx}_image_time"] : $_r['r_created']
                );
                $dat         = array();
                $mod         = (isset($_mods["{$_r['r_module']}"])) ? $_r['r_module'] : 'jrPayment';
                $profile_url = $_conf['jrCore_base_url'] . '/' . $_it['profile_url'];
                $item_url    = $_conf['jrCore_base_url'] . '/' . $_it['profile_url'] . '/' . jrCore_get_module_url($mod) . '/' . $_r['r_item_id'];
                if (isset($_r['r_item_data']["{$pfx}_image_time"]) && $_r['r_item_data']["{$pfx}_image_time"] > 0) {
                    $dat[1]['title'] = jrImage_get_image_src($_r['r_module'], "{$pfx}_image", $_r['r_item_id'], 'small', $_im);
                }
                else {
                    $dat[1]['title'] = jrCore_get_module_icon_html($mod, 48, 'payment-icon');
                }
                $dat[2]['title'] = '<a href="' . $item_url . '">' . $ttl . '</a><br><small>' . $_mods[$mod]['module_name'] . ' &bull; <a href="' . $profile_url . '">@' . $_it['profile_url'] . '</small></a>';
            }
            else {
                $mod             = (isset($_mods["{$_r['r_module']}"])) ? $_r['r_module'] : 'jrPayment';
                $dat[1]['title'] = jrCore_get_module_icon_html($mod, 48, 'payment-icon');
                $dat[2]['title'] = $_mods[$mod]['module_name'];
            }

            $uid = (int) $_r['r_purchase_user_id'];
            if (!empty($_id[$uid]) && is_array($_id[$uid])) {
                $dat[3]['title'] = "{$_id[$uid]['user_name']}<br><a href=\"{$_conf['jrCore_base_url']}/{$_id[$uid]['profile_url']}\" target=\"_blank\"><small>@{$_id[$uid]['profile_url']}</small></a>";
            }
            else {
                $dat[3]['title'] = jrCore_page_button("tr-assign-{$k}", 'assign', "jrCore_window_location('{$_conf['jrCore_base_url']}/{$_post['module_url']}/txn_assign/{$_r['r_txn_id']}')");
            }
            $dat[3]['class'] = 'center';

            if (isset($_r['r_refunded_time']) && $_r['r_refunded_time'] > 0) {
                if ($_r['r_refunded_amount'] < $_r['r_amount']) {
                    $dat[4]['title'] = jrPayment_get_currency_code() . jrPayment_currency_format($_r['r_amount'] - $_r['r_refunded_amount']);
                    $dat[4]['title'] .= '<br><small>' . jrPayment_get_currency_code() . jrPayment_currency_format($_r['r_refunded_amount']) . '&nbsp;refunded</small>';
                }
                else {
                    $dat[4]['title'] = '<strike>' . jrPayment_get_currency_code() . jrPayment_currency_format($_r['r_amount']) . '</strike>';
                    $dat[4]['title'] .= '<br><small>refunded</small>';
                }
                $dat[4]['class'] = 'center error';
            }
            elseif ($_r['r_field'] == 'transaction' && $_r['r_expense'] > 0 && $_r['r_amount'] == 0) {
                $dat[4]['title'] = '-' . jrPayment_get_currency_code() . jrPayment_currency_format($_r['r_expense']);
                $dat[4]['class'] = 'center';
            }
            else {
                $dat[4]['title'] = jrPayment_get_currency_code() . jrPayment_currency_format($_r['r_amount']);
                $dat[4]['class'] = 'center';
            }
            $dat[5]['title'] = jrCore_format_time($_r['r_created']) . '<br><small>' . $_r['r_gateway_id'] . '</small>';
            $dat[5]['class'] = 'center';
            $dat[6]['title'] = jrCore_page_button("txn-detail-{$k}", 'detail', "jrCore_window_location('{$_conf['jrCore_base_url']}/{$_post['module_url']}/txn_detail/{$_r['r_txn_id']}')");
            $dat[6]['class'] = 'center';

            // Trigger so individual modules can customize their row if needed
            $dat = jrCore_trigger_event('jrPayment', 'payment_entry', $dat, $_r, $_r['r_module']);
            if ($dat && is_array($dat) && count($dat) > 0) {
                jrCore_page_table_row($dat);
            }

        }
        jrCore_page_table_pager($_rt);
    }
    else {
        $dat = array();
        if (isset($_post['search_string']) && strlen($_post['search_string']) > 0) {
            $dat[1]['title'] = 'No transactions match your search criteria';
        }
        else {
            $dat[1]['title'] = 'No payments have been recorded yet';
        }
        $dat[1]['class'] = 'center p10';
        jrCore_page_table_row($dat);
    }
    jrCore_page_table_footer();
    jrCore_page_cancel_button('referrer');
    jrCore_page_display();
}
