<?php
 /**
 * Jamroom Payment Support module
 *
 * copyright 2023 The Jamroom Network
 *
 * This Jamroom file is LICENSED SOFTWARE, and cannot be redistributed.
 *
 * This Source Code is subject to the terms of the Jamroom Network
 * Commercial License -  please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: download
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrPayment_download($_post, $_user, $_conf)
{
    jrUser_session_require_login();
    if (!isset($_post['_1']) || !jrCore_checktype($_post['_1'], 'number_nz')) {
        jrCore_set_form_notice('error', 'invalid register id');
        jrCore_location('referrer');
    }

    // Make sure this user has purchased this vault file
    $_rg = jrPayment_get_register_entry_by_id($_post['_1']);
    if (!jrUser_is_admin() && (!$_rg || !is_array($_rg) || $_rg['r_purchase_user_id'] != $_user['_user_id'])) {
        jrCore_notice('error', 'It does not appear you have purchased this file - exiting');
    }

    // Has this item been refunded?
    if ($_rg['r_refunded_time'] > 0) {
        jrCore_notice('error', 'It does not appear you have purchased this file - exiting');
    }

    $alt = false;
    $_it = jrCore_db_get_item($_rg['r_module'], $_rg['r_item_id']);
    if (!$_it || !is_array($_it)) {
        // Looks like this item may have been deleted - let's see if
        // we have saved this item to the system vault
        if (!$_it = jrPayment_get_vault_item($_rg['r_module'], $_rg['r_item_id'])) {
            jrCore_notice('error', 'file not found');
        }
        $alt = true;
    }

    // When we get a VAULT download, we're going to be sending the
    // user the ORIGINAL file - not the down sampled copy.
    $fld = $_rg['r_field'];
    if (isset($_it["{$fld}_original_extension"])) {
        // jrVideo_38_video_file.mov.original.mov
        $ext = $_it["{$fld}_original_extension"];
        $nam = "{$_rg['r_module']}_{$_rg['r_item_id']}_{$fld}.{$ext}.original.{$ext}";
    }
    else {
        // We don't have an "original" - i.e. no conversion was done
        $nam = "{$_rg['r_module']}_{$_rg['r_item_id']}_{$fld}." . $_it["{$fld}_extension"];
    }

    if ($alt) {
        // This is a deleted file that has been saved in the vault
        $nam = "jrPayment_vault_{$_rg['r_module']}_{$_rg['r_item_id']}_{$fld}." . $_it["{$fld}_extension"];
    }

    $pfx = jrCore_db_get_prefix($_rg['r_module']);
    if (isset($_it["{$pfx}_title_url"])) {
        $ttl = $_it["{$pfx}_title_url"];
    }
    elseif (isset($_it["{$pfx}_title"])) {
        $ttl = jrCore_url_string($_it["{$pfx}_title_url"]);
    }
    elseif (isset($_it["{$fld}_original_name"])) {
        $ttl = jrCore_url_string($_it["{$fld}_original_name"]);
    }
    elseif (isset($_it["{$fld}_name"])) {
        $ttl = jrCore_url_string($_it["{$fld}_name"]);
    }
    else {
        $ttl = $nam;
    }
    $ttl = pathinfo($ttl, PATHINFO_FILENAME) . '.' . $_it["{$fld}_extension"];

    // "vault_download" event trigger
    $_args = array(
        'module'     => $_rg['r_module'],
        'file_name'  => $fld,
        'vault_file' => $nam,
        'vault_name' => $ttl,
        '_register'  => $_rg
    );
    $_it   = jrCore_trigger_event('jrPayment', 'vault_download', $_it, $_args);
    if (isset($_it['vault_file'])) {
        $nam = $_it['vault_file'];
    }
    if (isset($_it['vault_name'])) {
        $ttl = $_it['vault_name'];
    }
    if ($alt) {
        if (!jrCore_media_file_exists('system', $nam)) {
            jrCore_notice('CRI', 'Invalid media id - no file found: ' . $nam);
        }
    }

    // Increment our counter
    jrCore_db_increment_key($_rg['r_module'], $_it['_item_id'], "{$fld}_vault_download_count", 1);

    // Download the file to the client
    if ($alt) {
        jrCore_media_file_download('system', $nam, $ttl);
    }
    else {
        jrCore_media_file_download($_it['_profile_id'], $nam, $ttl);
    }
    session_write_close();
    exit();
}
