<?php
 /**
 * Jamroom Payment Support module
 *
 * copyright 2023 The Jamroom Network
 *
 * This Jamroom file is LICENSED SOFTWARE, and cannot be redistributed.
 *
 * This Source Code is subject to the terms of the Jamroom Network
 * Commercial License -  please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: create_register_entry_save
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrPayment_create_register_entry_save($_post, $_user, $_conf)
{
    jrUser_master_only();
    jrCore_form_validate($_post);

    // We have to first create the DS transaction THEN create the register entry
    $_tx = jrCore_form_get_save_data('jrPayment', 'create_register_entry', $_post);

    // If we got an email address, see if we can link it up to a user_id
    if (strpos($_tx['txn_user_email'], '@')) {
        if ($_us = jrCore_db_get_item_by_key('jrUser', 'user_email', $_tx['txn_user_email'], true)) {
            $_tx['txn_user_id'] = (int) $_us['_user_id'];
        }
    }
    if (!isset($_tx['txn_user_id'])) {
        $_tx['txn_user_id'] = 0;
    }
    $_tx['txn_total']    = jrPayment_price_to_cents($_tx['txn_total']);
    $_tx['txn_expense']  = jrPayment_price_to_cents($_tx['txn_expense']);
    $_tx['txn_tax']      = 0;
    $_tx['txn_shipping'] = 0;
    $_tx['txn_type']     = 'payment';
    $_tx['txn_currency'] = jrPayment_run_plugin_function('get_currency_code');
    $_cr                 = array(
        '_created' => $_tx['txn_date'],
        '_updated' => $_tx['txn_date']
    );
    if (!$tid = jrCore_db_create_item('jrPayment', $_tx, $_cr)) {
        // We had an error creating the item in the datastore
        jrCore_set_form_notice('error', 'an error was encountered saving the payment to the datastore - please try again');
        jrCore_form_result();
    }

    $_tx['_item_id']      = $tid; // use transaction DS id
    $_tx['_profile_id']   = 0;    // No profile is seller
    $_tx['cart_amount']   = $_tx['txn_total'];
    $_tx['cart_expense']  = $_tx['txn_expense'];
    $_tx['cart_shipping'] = 0;
    $_tx['cart_quantity'] = 1;
    $_tx['cart_module']   = 'jrPayment';
    $_tx['cart_field']    = 'transaction';

    // Create register entry
    if (jrPayment_record_sale_in_register($tid, $_tx['txn_id'], $_tx['txn_user_id'], $_tx, $_tx['txn_category'], 0, 0, $_tx['txn_date'])) {
        jrCore_form_delete_session();
        jrCore_set_form_notice('success', "The new payment transaction was successfully created");
        jrCore_location("{$_conf['jrCore_base_url']}/{$_post['module_url']}/payments");
    }
    jrCore_set_form_notice('error', 'an error was encountered saving the payment to the register - please try again');
    jrCore_form_result();
}
