<?php
 /**
 * Jamroom Payment Support module
 *
 * copyright 2023 The Jamroom Network
 *
 * This Jamroom file is LICENSED SOFTWARE, and cannot be redistributed.
 *
 * This Source Code is subject to the terms of the Jamroom Network
 * Commercial License -  please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: checkout
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrPayment_checkout($_post, $_user, $_conf)
{
    if (!isset($_post['_1']) || !jrCore_checktype($_post['_1'], 'md5')) {
        jrCore_notice_page('error', 'invalid checkout id - please try again');
    }
    $_cr = jrPayment_get_user_cart();
    if ($_cr && is_array($_cr) && isset($_cr['_items'])) {

        if (!isset($_cr['cart_hash']) || $_cr['cart_hash'] != $_post['_1']) {
            jrCore_notice_page('error', 'invalid cart validation - please try again');
        }

        $amt = 0;
        foreach ($_cr['_items'] as $_i) {
            $amt += ($_i['cart_amount'] * $_i['cart_quantity']);
            if (!empty($_i['cart_shipping']) && jrCore_checktype($_i['cart_shipping'], 'number_nz')) {
                $amt += (int) ($_i['cart_shipping'] * $_i['cart_quantity']);
            }
        }
        if (isset($_conf['jrPayment_cart_charge']) && $_conf['jrPayment_cart_charge'] > 0) {
            $amt += intval($_conf['jrPayment_cart_charge'] * 100);
        }
        $plg = null;
        if (isset($_post['_2']) && strlen($_post['_2']) > 0 && jrPayment_is_valid_plugin($_post['_2'])) {
            $plg = $_post['_2'];
        }
        $url = jrPayment_get_checkout_url($amt, $_cr, $plg);
        if ($url && jrCore_checktype($url, 'url')) {
            $_ur = array(
                'checkout_url' => $url
            );
            $_ur = jrCore_trigger_event('jrPayment', 'cart_checkout', $_ur, $_cr);
            if (isset($_ur['checkout_url']) && jrCore_checktype($_ur['checkout_url'], 'url')) {
                jrCore_location($url);
            }
            jrCore_notice_page('error', 'invalid checkout URL:<br>' . $url, null, null, false);
        }
        jrCore_notice_page('error', 'error building checkout URL for payment processor - please try again');
    }
    jrCore_notice_page('error', 'no cart items found to checkout with - please try again');
}
