<?php
 /**
 * Jamroom Payment Support module
 *
 * copyright 2023 The Jamroom Network
 *
 * This Jamroom file is LICENSED SOFTWARE, and cannot be redistributed.
 *
 * This Source Code is subject to the terms of the Jamroom Network
 * Commercial License -  please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: cart
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrPayment_cart($_post, $_user, $_conf)
{
    $_ln = jrUser_load_lang_strings();
    $_cr = jrPayment_get_user_cart();

    jrCore_page_set_no_header_or_footer();

    $button = jrCore_page_button('continue', $_ln['jrPayment'][5], 'jrPayment_close_cart()');
    jrCore_page_banner($_ln['jrPayment'][6], $button);
    jrCore_get_form_notice();

    $dat             = array();
    $dat[1]['title'] = '&nbsp;';
    $dat[1]['width'] = '5%';
    $dat[2]['title'] = $_ln['jrPayment'][7];
    $dat[2]['width'] = '61%';
    $dat[3]['title'] = $_ln['jrPayment'][8];
    $dat[3]['width'] = '17%';
    $dat[4]['title'] = $_ln['jrPayment'][9];
    $dat[4]['width'] = '17%';
    jrCore_page_table_header($dat);

    if ($_cr && is_array($_cr) && isset($_cr['_items'])) {

        // Do we have modules that need quantity support?
        $_qs = jrCore_get_registered_module_features('jrPayment', 'quantity_support');

        // Save cart validation - will be used in webhook to validate cart content
        $md5 = jrPayment_save_cart_validation($_cr);

        $tot = 0;
        $shp = 0;
        $sym = jrPayment_get_currency_code();
        foreach ($_cr['_items'] as $eid => $_i) {

            $pfx = jrCore_db_get_prefix($_i['cart_module']);
            $fld = str_replace('_', ' ', str_replace('_item_price', '', $_i['cart_field']));
            $dat = array();
            if (isset($_i["{$pfx}_image_time"])) {
                $_im             = array(
                    'crop'   => 'auto',
                    'width'  => 40,
                    'height' => 40,
                    'alt'    => 'img',
                    'title'  => 'img',
                    'class'  => 'module_icon payment-icon',
                    '_v'     => ($_i["{$pfx}_image_time"] > 0) ? $_i["{$pfx}_image_time"] : 1
                );
                $dat[1]['title'] = jrImage_get_image_src($_i['cart_module'], "{$pfx}_image", $_i['cart_item_id'], 'icon', $_im);
            }
            else {
                $dat[1]['title'] = jrCore_get_module_icon_html($_i['cart_module'], 40, 'payment-icon');
            }
            $dat[2]['title'] = $_i["{$pfx}_title"];
            if (isset($_i['profile_url'])) {
                $dat[2]['title'] .= '<br><small><a href="' . $_conf['jrCore_base_url'] . '/' . $_i['profile_url'] . '">@' . $_i['profile_url'] . '</a> &bull; ' . $fld . '</small>';
            }
            $dat[2]['class'] = 'p5';

            if (isset($_qs["{$_i['cart_module']}"]) && jrCore_checktype($_qs["{$_i['cart_module']}"], 'is_true')) {
                $dat[3]['title'] = '<input id="q' . $eid . '" type="text" value="' . $_i['cart_quantity'] . '" class="cart-qty" data-eid="' . $eid . '" onkeypress="if (event && event.keyCode == 13 && this.value.length > 0) { jrPayment_update_quantity(' . $eid . '); }">';
                $dat[3]['title'] .= '<br><input type="button" class="form_button cart-remove-button" value="update" onclick="jrPayment_update_quantity(' . intval($eid) . ')">';
            }
            else {
                $dat[3]['title'] = $_i['cart_quantity'];
                $dat[3]['title'] .= '<br><input type="button" class="form_button cart-remove-button" value="remove" onclick="jrPayment_remove_item(\'' . $eid . '\')">';
            }
            $dat[3]['class'] = 'center';

            $tot             += ($_i['cart_amount'] * $_i['cart_quantity']);
            $dat[4]['title'] = $sym . '<span id="entry-total-' . $eid . '">' . jrPayment_currency_format($_i['cart_amount'] * $_i['cart_quantity']) . '</span>';
            $dat[4]['class'] = 'center';

            // Get shipping
            // allow for 3rd party S&H events
            $ish = 0;
            $tmp = jrCore_trigger_event('jrPayment', 'cart_shipping_alt', $dat, $_i);
            if ($tmp && jrCore_checktype($tmp, 'number_nz')) {
                $shp += (int) $tmp;
                $ish = (int) $tmp;
            }
            else {
                // Trigger individual module
                $tmp = jrCore_trigger_event('jrPayment', 'cart_shipping', $dat, $_i, $_i['cart_module']);
                if ($tmp && jrCore_checktype($tmp, 'number_nz')) {
                    $shp += (int) ($_i['cart_quantity'] * $tmp);
                    $ish = (int) $tmp;
                }
            }
            if ($ish > 0) {
                $dat[4]['title'] .= "<br><span class=\"cart-shipping\">+{$sym}" . jrPayment_currency_format($_i['cart_quantity'] * $ish) . ' ' . $_ln['jrPayment'][10] . '</span>';
            }
            if ($shp > 0) {
                $tot += $shp;
            }

            // Get entry
            $dat = jrCore_trigger_event('jrPayment', 'cart_entry', $dat, $_i, $_i['cart_module']);
            jrCore_page_table_row($dat, 'cart-item-row');
        }

        // Service Charge
        if (isset($_conf['jrPayment_cart_charge']) && $_conf['jrPayment_cart_charge'] > 0) {
            $dat             = array();
            $dat[1]['title'] = '&nbsp;';
            $dat[1]['class'] = '" style="text-align:right" colspan="2';
            $dat[2]['title'] = "{$_ln['jrPayment'][35]}";
            $dat[2]['class'] = 'center';
            $dat[3]['title'] = $sym . '<span id="cart-charge-total">' . jrPayment_currency_format($_conf['jrPayment_cart_charge']) . '</span>';
            $dat[3]['class'] = 'center p5';
            jrCore_page_table_row($dat);
            $tot += ($_conf['jrPayment_cart_charge'] * 100);
        }

        $dat             = array();
        $dat[1]['title'] = '&nbsp;';
        $dat[1]['class'] = '" style="text-align:right" colspan="2';
        $dat[2]['title'] = $_ln['jrPayment'][11];
        $dat[2]['class'] = 'center';
        $dat[3]['title'] = "<b>{$sym}" . '<span id="cart-checkout-total">' . jrPayment_currency_format($tot) . '</span></b>';
        $dat[3]['class'] = 'center p5';
        jrCore_page_table_row($dat);

        if (!jrUser_is_logged_in()) {
            $onc = 'jrPayment_checkout_login()';
        }
        else {
            // Our plugin can give us a DIRECT URL (so we don't redirect)
            if (!$onc = jrPayment_run_plugin_function('checkout_onclick', $md5, $tot, $_cr)) {
                $onc = "jrCore_window_location('{$_conf['jrCore_base_url']}/{$_post['module_url']}/checkout/{$md5}')";
            }
        }

        $dat             = array();
        $dat[1]['title'] = '&nbsp';
        if (isset($_conf['jrPayment_show_clear']) && $_conf['jrPayment_show_clear'] == 'on') {
            $dat[1]['title'] = jrCore_page_button('reset', $_ln['jrPayment'][26], 'jrPayment_reset_cart()');
        }
        $dat[1]['class'] = 'left" colspan="3';
        $dat[2]['title'] = jrCore_page_button('checkout', $_ln['jrPayment'][12], $onc, array('class' => 'form_checkout_button form_button'));
        $dat[2]['class'] = 'p10 center jrpayment_checkout_cell';
        if (jrPayment_get_active_plugin() != 'paypal' && jrUser_is_logged_in() && isset($_conf['jrPayment_show_paypal']) && $_conf['jrPayment_show_paypal'] == 'on') {
            jrPayment_set_active_plugin('paypal');
            if ($pnc = jrPayment_run_plugin_function('checkout_onclick', $md5, $tot, $_cr)) {
                $dat[2]['title'] .= "<br><span>{$_ln['jrPayment'][56]}</span><br><img src=\"{$_conf['jrCore_base_url']}/image/img/module/jrPayment/paypal_co.png\" onclick=\"{$pnc}\" alt=\"PayPal\">";
            }
            jrPayment_set_active_plugin($_conf['jrPayment_plugin']);
        }
        $dat = jrCore_trigger_event('jrPayment', 'cart_checkout_row', $dat, $_cr);
        jrCore_page_table_row($dat, 'payment-checkout-cell');

    }
    else {
        $dat             = array();
        $dat[1]['title'] = $_ln['jrPayment'][13];
        $dat[1]['class'] = 'center p10';
        jrCore_page_table_row($dat);
    }
    jrCore_page_table_footer();

    // Do we have any cart javascript elements?
    $js = jrPayment_run_plugin_function('cart_elements');
    if (!$js) {
        $js = '';
    }

    return '<div id="cart-holder">' . jrCore_page_display(true) . $js . '</div>';
}
