<?php
 /**
 * Jamroom Newsletters module
 *
 * copyright 2024 The Jamroom Network
 *
 * This Jamroom file is LICENSED SOFTWARE, and cannot be redistributed.
 *
 * This Source Code is subject to the terms of the Jamroom Network
 * Commercial License -  please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: user
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrNewsLetter_user($_post, $_user, $_conf)
{
    if (isset($_post['_1']) && jrCore_checktype($_post['_1'], 'number_nz') && isset($_post['_2']) && jrCore_checktype($_post['_2'], 'md5')) {
        $_rt = jrCore_db_get_item_by_key('jrUser', 'user_validate', $_post['_2']);
        if ($_rt && is_array($_rt)) {
            $lid = (int) $_post['_1'];
            $uid = (int) $_rt['_item_id'];
            $tbl = jrCore_db_table_name('jrNewsLetter', 'track');
            $req = "INSERT INTO {$tbl} (t_uid, t_lid) VALUES ('{$uid}', '{$lid}') ON DUPLICATE KEY UPDATE t_uid = '{$uid}'";
            jrCore_db_query($req);
        }
    }
    // Send out image
    header("Content-type: image/gif");
    header('Content-Disposition: inline; filename="1.gif"');
    header('Expires: ' . gmdate('D, d M Y H:i:s \G\M\T', time() + 8640000));
    echo file_get_contents(APP_DIR . '/modules/jrNewsLetter/img/1.gif');
    exit();
}
