<?php
 /**
 * Jamroom Newsletters module
 *
 * copyright 2024 The Jamroom Network
 *
 * This Jamroom file is LICENSED SOFTWARE, and cannot be redistributed.
 *
 * This Source Code is subject to the terms of the Jamroom Network
 * Commercial License -  please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: get_recipient_info
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrNewsLetter_get_recipient_info($_post, $_user, $_conf)
{
    ini_set('max_execution_time', 60);
    jrUser_master_only();
    jrCore_validate_location_url();
    $_rt = array();
    if (isset($_post['letter_quota']) && is_array($_post['letter_quota'])) {
        // Are we doing tests?
        foreach ($_post['letter_quota'] as $opt) {
            if (strpos(' ' . $opt, 'test_')) {
                // This is a test
                switch ($opt) {
                    case 'test_user':
                        $_rt["{$_user['_user_id']}"] = $_user['user_email'];
                        break;
                    case 'test_master':
                    case 'test_admin':
                        if ($opt == 'test_master') {
                            $_us = jrUser_get_master_user_ids();
                        }
                        else {
                            $_us = jrUser_get_admin_user_ids();
                        }
                        $_tm = jrCore_db_get_multiple_items('jrUser', $_us, array('_user_id', 'user_email'));
                        if ($_tm && is_array($_tm)) {
                            foreach ($_tm as $_u) {
                                $_rt["{$_u['_user_id']}"] = $_u['user_email'];
                            }
                        }
                        break;
                }
            }
        }
    }
    if (count($_rt) === 0) {
        $_custom = array();
        foreach ($_post as $k => $v) {
            if (strpos($k, 'letter_custom') === 0 && !empty($v)) {
                $_custom[] = trim($v);
            }
        }
        $size = (isset($_conf['jrNewsLetter_show_recipient_count']) && jrCore_checktype($_conf['jrNewsLetter_show_recipient_count'], 'number_nz')) ? $_conf['jrNewsLetter_show_recipient_count'] : 5000;
        $_rt  = jrNewsLetter_get_matching_recipients($_post['letter_quota'], $_post['letter_filter'], $_custom, false, $size);
    }

    jrCore_page_set_no_header_or_footer();
    $button = jrCore_page_button('close', 'close', '$.modal.close()');
    jrCore_page_banner('Recipient Addresses', $button);

    $dat             = array();
    $dat[1]['title'] = 'ID';
    $dat[1]['width'] = '10%';
    $dat[2]['title'] = 'email address';
    $dat[2]['width'] = '90%';
    jrCore_page_table_header($dat);
    if (is_array($_rt) && count($_rt) > 0) {
        ksort($_rt, SORT_NUMERIC);
        foreach ($_rt as $uid => $e) {
            $dat             = array();
            $dat[1]['title'] = $uid;
            $dat[1]['class'] = 'center';
            $dat[2]['title'] = $e;
            jrCore_page_table_row($dat);
        }
    }
    else {
        $dat             = array();
        $dat[1]['title'] = 'no matching email addresses found';
        $dat[1]['class'] = 'center';
        jrCore_page_table_row($dat);
    }
    jrCore_page_table_footer();
    jrCore_page_cancel_button('modal_close', 'close');
    jrCore_page_display();
}
