<?php
 /**
 * Jamroom Newsletters module
 *
 * copyright 2024 The Jamroom Network
 *
 * This Jamroom file is LICENSED SOFTWARE, and cannot be redistributed.
 *
 * This Source Code is subject to the terms of the Jamroom Network
 * Commercial License -  please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: edit_newsletter_template
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrNewsLetter_edit_newsletter_template($_post, $_user, $_conf)
{
    jrUser_session_require_login();
    jrUser_master_only();
    jrCore_page_include_admin_menu();
    jrCore_page_admin_tabs('jrNewsLetter');

    $button = jrCore_page_button('new', 'New Newsletter from this Template', "jrCore_window_location('{$_conf['jrCore_base_url']}/{$_post['module_url']}/compose/tid={$_post['id']}')");
    jrCore_page_banner('Edit Newsletter Template', $button);
    if (isset($_SESSION['new_template_notice'])) {
        jrCore_set_form_notice('success', 'The template was successfully created');
        unset($_SESSION['new_template_notice']);
    }
    jrCore_get_form_notice();

    $_rt = jrNewsLetter_get_template($_post['id']);

    // Form init
    $_tmp = array(
        'submit_value'     => 'Save Changes',
        'cancel'           => "{$_conf['jrCore_base_url']}/{$_post['module_url']}/admin/tools",
        'form_ajax_submit' => false,
        'values'           => $_rt
    );
    jrCore_form_create($_tmp);

    // Hidden - template id
    $_tmp = array(
        'name'  => 'template_id',
        'type'  => 'hidden',
        'value' => $_post['id']
    );
    jrCore_form_field_create($_tmp);

    // Newsletter subject
    $_tmp = array(
        'name'     => 't_title',
        'label'    => 'Template Title',
        'help'     => 'This is the name of the Template as it will appear in the Template Browser',
        'type'     => 'text',
        'validate' => 'not_empty',
        'required' => true
    );
    jrCore_form_field_create($_tmp);

    // Newsletter message
    $_tmp = array(
        'name'       => 't_template',
        'label'      => 'Template Content',
        'help'       => 'Enter the content of this template (required)',
        'type'       => 'editor',
        'validate'   => 'allowed_html',
        'full_width' => true,
        'required'   => true
    );
    jrCore_form_field_create($_tmp);
    jrCore_page_display();
}
