<?php
 /**
 * Jamroom Newsletters module
 *
 * copyright 2024 The Jamroom Network
 *
 * This Jamroom file is LICENSED SOFTWARE, and cannot be redistributed.
 *
 * This Source Code is subject to the terms of the Jamroom Network
 * Commercial License -  please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: compose
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrNewsLetter_compose($_post, $_user, $_conf)
{
    global $_mods;
    jrUser_session_require_login();
    jrUser_master_only();
    jrCore_page_include_admin_menu();
    jrCore_page_admin_tabs('jrNewsLetter');

    $did = 0;
    $_vl = false;
    $val = 'Save Draft';
    if (isset($_post['draft']) && jrCore_checktype($_post['draft'], 'number_nz')) {
        $did = (int) $_post['draft'];
        $_vl = jrCore_db_get_item('jrNewsLetter', $_post['draft'], true, true);
        if (isset($_vl['letter_custom']) && strpos($_vl['letter_custom'], '[') === 0) {
            $_tmp = json_decode($_vl['letter_custom'], true);
            if ($_tmp && is_array($_tmp) && count($_tmp) > 0) {
                foreach ($_tmp as $k => $v) {
                    $idx                        = $k + 1;
                    $_vl["letter_custom{$idx}"] = $v;
                }
            }
        }
        $val = 'Save Changes';
    }

    $tmp = '<img id="save_indicator" style="display:none;" src="' . $_conf['jrCore_base_url'] . '/skins/' . $_conf['jrCore_active_skin'] . '/img/submit.gif" width="24" height="24" alt="working...">&nbsp;' . jrCore_page_button('letter_save', $val, "jrNewsLetter_save();");

    if (!isset($_post['tid'])) {
        $tmp .= jrCore_page_button('tpl', 'Save As New Template', "jrNewsLetter_check_template()");
    }

    jrCore_page_banner('Compose Newsletter', $tmp);
    jrCore_get_form_notice();

    // Form init
    $lurl = jrCore_get_local_referrer();
    if (!strpos($lurl, '/compose')) {
        jrCore_create_memory_url('compose_cancel', $lurl);
    }
    if (!$curl = jrCore_get_memory_url('compose_cancel')) {
        $curl = 'referrer';
    }
    $_tmp = array(
        'submit_value'     => 'Send Newsletter',
        'cancel'           => $curl,
        'submit_prompt'    => 'Send this newsletter to the selected recipients?',
        'form_ajax_submit' => false,
        'values'           => $_vl
    );
    jrCore_form_create($_tmp);

    // Get templates
    if (!isset($_post['draft']) && !isset($_post['tid'])) {
        $_rt = jrNewsLetter_get_templates();
        if ($_rt && is_array($_rt)) {
            $_sel    = array();
            $_sel[0] = '-';
            foreach ($_rt as $tid => $ttl) {
                $_sel[$tid] = $ttl;
            }
            $_tmp = array(
                'name'     => 'letter_template',
                'label'    => 'newsletter templates',
                'sublabel' => 'select as a starting point',
                'type'     => 'select',
                'options'  => $_sel,
                'default'  => (isset($_post['tid']) && jrCore_checktype($_post['tid'], 'number_nz')) ? intval($_post['tid']) : 0,
                'validate' => 'not_empty',
                'required' => true,
                'onchange' => "var nid=$(this).val(); if(nid > 0) { self.location='{$_conf['jrCore_base_url']}/{$_post['module_url']}/compose/tid='+ nid } else { jrNewsLetter_compose_new() }"
            );
            jrCore_form_field_create($_tmp);
            jrCore_page_divider();
        }
    }

    // Are we loading a template?
    $val = (isset($_vl['letter_message'])) ? $_vl['letter_message'] : '';
    $ttl = '';
    if (isset($_post['tid']) && jrCore_checktype($_post['tid'], 'number_nz')) {
        $_tp = jrNewsLetter_get_template($_post['tid']);
        $val = $_tp['t_template'];
        $ttl = $_tp['t_title'];
    }

    // Hidden - Template Title
    $_tmp = array(
        'name'  => 'template_title',
        'type'  => 'hidden',
        'value' => $ttl
    );
    jrCore_form_field_create($_tmp);

    // Hidden - Draft ID
    $_tmp = array(
        'name'  => 'letter_id',
        'type'  => 'hidden',
        'value' => $did
    );
    jrCore_form_field_create($_tmp);

    // Newsletter subject
    $_tmp = array(
        'name'     => 'letter_title',
        'label'    => 'Newsletter Subject',
        'sublabel' => 'should be unique',
        'help'     => 'Enter the newsletter subject (required).<br><br><b>IMPORTANT!</b> To properly monitor for bounced emails, ensure EACH Newsletter has a unique subject line!',
        'type'     => 'text',
        'validate' => 'not_empty',
        'required' => true
    );
    jrCore_form_field_create($_tmp);

    // Newsletter message
    $_tmp = array(
        'name'       => 'letter_message',
        'label'      => 'Newsletter Content',
        'help'       => 'Enter the newsletter content (required)',
        'type'       => 'editor',
        'full_width' => true,
        'value'      => $val,
        'validate'   => 'allowed_html',
        'required'   => true
    );
    jrCore_form_field_create($_tmp);

    // Number of recipients
    $html = jrCore_parse_template('recipient_count.tpl', $_post, 'jrNewsLetter');
    jrCore_page_custom($html, 'Matching Recipient Count', 'with filters applied');

    // Select recipients
    $_rec = array(
        'test_user'   => "Test: Send to {$_user['user_email']}",
        'test_master' => "Test: Send to Master Admins",
        'test_admin'  => "Test: Send to Master + Profile Admins",
        '0'           => 'All Quotas',
    );
    $_qt  = jrProfile_get_quotas();
    foreach ($_qt as $id => $name) {
        $_rec[$id] = $name;
    }

    // Get Quota names
    $_tmp = array(
        'name'     => 'letter_quota',
        'label'    => 'Recipient Quotas',
        'sublabel' => 'multiple selections allowed',
        'help'     => 'Select the Quotas you would like to send this newsletter to',
        'type'     => 'select_multiple',
        'options'  => $_rec,
        'default'  => 'test_user',
        'value'    => (isset($_vl['letter_quota'])) ? $_vl['letter_quota'] : 'test_user',
        'validate' => 'not_empty',
        'required' => true
    );
    jrCore_form_field_create($_tmp);

    // Get Filters
    $help = 'Select the filters you would like to apply to the Selected Recipients.<br><br><b>NOTE:</b> Filters are ignored when sending a test email to yourself.<br><br>The following modules provide filters:<br>';
    $_rec = array(
        0 => 'No Filter Applied'
    );
    $_tmp = jrCore_trigger_event('jrNewsLetter', 'newsletter_filters', array());
    if ($_tmp && is_array($_tmp)) {
        foreach ($_tmp as $mod => $_filters) {
            $help .= "<br><b>{$_mods[$mod]['module_name']}</b>:<br>";
            foreach ($_filters as $id => $title) {
                $_rec["{$mod}:{$id}"] = $title;
                $help                 .= "<small>{$title}</small><br>";
            }
        }
    }
    $_tmp = array(
        'name'     => 'letter_filter',
        'label'    => 'module filters',
        'sublabel' => 'multiple selections allowed',
        'help'     => $help,
        'type'     => 'select_multiple',
        'options'  => $_rec,
        'default'  => 0,
        'value'    => (isset($_vl['letter_filter'])) ? $_vl['letter_filter'] : 0,
        'validate' => 'not_empty',
        'required' => true
    );
    jrCore_form_field_create($_tmp);

    foreach (range(1, 3) as $idx) {
        $_tmp = array(
            'name'     => "letter_custom{$idx}",
            'label'    => "custom filter {$idx}",
            'help'     => 'Enter a custom User or Profile filter to be applied to the recipient list.  The format for a custom filter is:<br><br>[field] [operator] [match_value]<br><br><b>NOTE:</b> Only User and Profile fields are supported.<br><br>For more information on custom filters reference the <a href="https://www.jamroom.net/the-jamroom-network/documentation/modules/283/email-newsletters">NewsLetter module documentation</a>.',
            'type'     => 'text',
            'value'    => (!empty($_vl["letter_custom{$idx}"])) ? $_vl["letter_custom{$idx}"] : '',
            'validate' => 'not_empty',
            'required' => false
        );
        jrCore_form_field_create($_tmp);
    }

    // Scheduled
    $_tmp = array(
        'name'     => 'letter_scheduled',
        'label'    => 'Send Date',
        'help'     => 'Select a future date for when this newsletter will be sent automatically',
        'type'     => 'date',
        'validate' => 'number_nz',
        'required' => true
    );
    jrCore_form_field_create($_tmp);

    // Ignore Unsubscribed
    $_tmp = array(
        'name'     => 'letter_ignore_unsub',
        'label'    => 'ignore preferences',
        'help'     => 'Check this option to send this newsletter to ALL users regardless of their newsletter preferences.<br><br>This can be useful for site communication where you need to contact all users.  Overriding user preferences when sending an actual Newsletter is not recommended - you will increase the chance of your messages being marked as spam.',
        'type'     => 'checkbox',
        'default'  => 'off',
        'validate' => 'onoff',
        'required' => true
    );
    jrCore_form_field_create($_tmp);

    $html = jrCore_parse_template('save_as_template.tpl', $_post, 'jrNewsLetter');
    jrCore_page_custom($html);
    jrCore_page_display();
}
