<?php
 /**
 * Jamroom Newsletters module
 *
 * copyright 2024 The Jamroom Network
 *
 * This Jamroom file is LICENSED SOFTWARE, and cannot be redistributed.
 *
 * This Source Code is subject to the terms of the Jamroom Network
 * Commercial License -  please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: browse
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrNewsLetter_browse($_post, $_user, $_conf)
{
    jrUser_session_require_login();
    jrUser_master_only();
    jrCore_page_include_admin_menu();
    jrCore_page_admin_tabs('jrNewsLetter', 'browse');

    $button = jrCore_page_button('create', 'Create a New Newsletter', "jrCore_window_location('{$_conf['jrCore_base_url']}/{$_post['module_url']}/compose')");
    jrCore_page_banner('Newsletter Browser', $button);
    jrCore_get_form_notice();

    $_sc = array(
        'order_by'       => array(
            'letter_sent' => 'numerical_desc'
        ),
        'skip_triggers'  => true,
        'ignore_pending' => true,
        'privacy_check'  => false,
        'no_cache'       => true,
        'pagebreak'      => jrCore_get_pager_rows(),
        'page'           => (isset($_post['p']) && jrCore_checktype($_post['p'], 'number_nz')) ? (int) $_post['p'] : 1
    );
    $_rt = jrCore_db_search_items('jrNewsLetter', $_sc);

    $dat             = array();
    $dat[1]['title'] = 'subject';
    $dat[1]['width'] = '57%';
    $dat[2]['title'] = 'sent';
    $dat[2]['width'] = '25%';
    $dat[3]['title'] = 'recipients';
    $dat[3]['width'] = '8%';
    $dat[4]['title'] = 'stats';
    $dat[4]['width'] = '5%';
    $dat[5]['title'] = 'delete';
    $dat[5]['width'] = '5%';
    jrCore_page_table_header($dat);

    if ($_rt && is_array($_rt) && is_array($_rt['_items'])) {

        // Get campaign SENT counts for each newsletter that is NOT a draft
        $_cn = array();
        $_id = array();
        foreach ($_rt['_items'] as $_l) {
            if (isset($_l['letter_campaign_id']) && (!isset($_l['letter_draft']) || $_l['letter_draft'] == 0)) {
                $_id[] = (int) $_l['letter_campaign_id'];
            }
        }
        if (count($_id) > 0) {
            $tbl = jrCore_db_table_name('jrMailer', 'campaign');
            $req = "SELECT c_id, c_sent FROM {$tbl} WHERE c_id IN('" . implode("','", $_id) . "')";
            $_cn = jrCore_db_query($req, 'c_id', false, 'c_sent');
        }

        $url = jrCore_get_module_url('jrMailer');
        foreach ($_rt['_items'] as $k => $_l) {
            $sch             = strtotime($_l['letter_scheduled']);
            $dat             = array();
            $dat[1]['title'] = "<a onclick=\"popwin('{$_conf['jrCore_base_url']}/{$_post['module_url']}/quick_view/{$_l['_item_id']}','Quick View {$_l['_item_id']}',900,600,'yes')\">{$_l['letter_title']}</a>";
            if (isset($_l['letter_draft']) && $_l['letter_draft'] == 1) {
                $dat[1]['class'] = 'error';
                $dat[2]['title'] = ($sch > time()) ? 'Scheduled ' . jrCore_format_time($sch, true) : 'UNSENT';
                $dat[2]['class'] = 'center error';
                $dat[3]['title'] = '-';
                $dat[3]['class'] = 'center error';
                $dat[4]['title'] = jrCore_page_button("r{$k}", 'edit', "jrCore_window_location('{$_conf['jrCore_base_url']}/{$_post['module_url']}/compose/draft={$_l['_item_id']}')");
                $dat[4]['class'] = 'center error';
                $dat[5]['class'] = 'error';
            }
            else {
                $dat[2]['title'] = jrCore_format_time($_l['_updated']);
                $dat[2]['class'] = 'center';
                $dat[3]['title'] = (isset($_l['letter_campaign_id']) && isset($_cn["{$_l['letter_campaign_id']}"])) ? jrCore_number_format($_cn["{$_l['letter_campaign_id']}"]) : jrCore_number_format($_l['letter_recipients']);
                $dat[3]['class'] = 'center';
                if (isset($_l['letter_campaign_id']) && jrCore_checktype($_l['letter_campaign_id'], 'number_nz')) {
                    $dat[4]['title'] = jrCore_page_button("r{$k}", 'view stats', "jrCore_window_location('{$_conf['jrCore_base_url']}/{$url}/campaign_result/{$_l['letter_campaign_id']}')");
                }
                else {
                    $dat[4]['title'] = jrCore_page_button("r{$k}", 'view stats', 'disabled');
                }
            }
            $dat[5]['title'] = jrCore_page_button("d{$k}", 'delete', "jrCore_confirm('', 'Delete this newsletter?', function() { jrCore_window_location('{$_conf['jrCore_base_url']}/{$_post['module_url']}/delete_save/id={$_l['_item_id']}') } )");
            jrCore_page_table_row($dat);
        }
        jrCore_page_table_pager($_rt);
    }
    else {
        $dat             = array();
        $dat[1]['title'] = '<p>No Newsletters have been created - press Create a New Newsletter above to create one.</p>';
        $dat[1]['class'] = 'p10 center';
        jrCore_page_table_row($dat);
    }
    jrCore_page_table_footer();
    jrCore_page_cancel_button("{$_conf['jrCore_base_url']}/{$_post['module_url']}/admin/tools");
    jrCore_page_display();
}
