<?php
 /**
 * Jamroom Newsletters module
 *
 * copyright 2024 The Jamroom Network
 *
 * This Jamroom file is LICENSED SOFTWARE, and cannot be redistributed.
 *
 * This Source Code is subject to the terms of the Jamroom Network
 * Commercial License -  please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: archive
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrNewsLetter_archive($_post, $_user, $_conf)
{
    // Must be logged in
    jrUser_session_require_login();

    jrCore_page_banner('Your Newsletter Archive');

    // Show newsletters that the user has received
    // Note that this uses the newsletter_emails database table, however, this will only retrieve newsletters going back to May 2016 (when the table was created).
    // Get a page worth of newsletter IDs that the user will have received
    $_nl = array();
    $tbl = jrCore_db_table_name('jrNewsLetter', 'emails');
    $req = "SELECT e_lid FROM {$tbl} WHERE e_emails LIKE '%{$_user['user_email']}%' ORDER BY e_time DESC";
    $_rt = jrCore_db_paged_query($req, $_post['p'], jrCore_get_pager_rows());
    if ($_rt && is_array($_rt['_items']) && count($_rt['_items']) > 0) {
        $_iids = array();
        foreach ($_rt['_items'] as $rt) {
            $nid         = (int) $rt['e_lid'];
            $_iids[$nid] = $nid;
        }
        $iids        = implode(',', $_iids);
        $_s          = array(
            'search'         => array("_item_id in {$iids}"),
            'order_by'       => array('letter_sent' => 'numerical_desc'),
            'skip_triggers'  => true,
            'ignore_pending' => true,
            'privacy_check'  => false,
            'limit'          => jrCore_get_pager_rows()
        );
        $_nl         = jrCore_db_search_items('jrNewsLetter', $_s);
        $_nl['info'] = $_rt['info'];
    }
    $_lang = jrUser_load_lang_strings();
    if ($_nl && is_array($_nl['_items']) && count($_nl['_items']) > 0) {
        // Show archive
        $dat             = array();
        $dat[1]['title'] = $_lang['jrNewsLetter'][5];
        $dat[1]['width'] = '25%';
        $dat[2]['title'] = $_lang['jrNewsLetter'][6];
        $dat[2]['width'] = '75%';
        jrCore_page_table_header($dat);
        foreach ($_nl['_items'] as $nl) {
            $dat             = array();
            $dat[1]['title'] = jrCore_format_time($nl['letter_sent']);
            $dat[1]['class'] = 'center';
            $dat[2]['title'] = '<h3><a href="' . $_conf['jrCore_base_url'] . '/' . $_post['module_url'] . '/archive_view/' . $nl['_item_id'] . '">' . $nl['letter_title'] . '</a></h3>';
            jrCore_page_table_row($dat);
        }
        jrCore_page_table_pager($_nl);
        jrCore_page_table_footer();
    }
    else {
        jrCore_page_notice('error', $_lang['jrNewsLetter'][7]);
    }
    jrCore_page_display();
}
