<?php
 /**
 * Jamroom Marketplace module
 *
 * copyright 2024 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: release_channels
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrMarket_release_channels($_post, $_user, $_conf)
{
    jrUser_master_only();
    jrCore_page_include_admin_menu();
    jrCore_page_admin_tabs('jrMarket');
    jrCore_page_banner('marketplace channels');
    jrCore_get_form_notice();

    $pass = jrCore_get_option_image('pass');
    $fail = jrCore_get_option_image('fail');

    $tbl = jrCore_db_table_name('jrMarket', 'channel');
    $tbs = jrCore_db_table_name('jrMarket', 'system');
    $req = "SELECT c.*, s.system_name FROM {$tbl} c LEFT JOIN {$tbs} s ON s.system_id = c.channel_system_id ORDER BY s.system_name ASC, c.channel_id ASC";
    $_rt = jrCore_db_query($req, 'NUMERIC');

    $dat             = array();
    $dat[1]['title'] = 'channel&nbsp;name';
    $dat[1]['width'] = '60%';
    $dat[2]['title'] = 'channel&nbsp;type';
    $dat[2]['width'] = '15%';
    $dat[3]['title'] = 'status';
    $dat[3]['width'] = '15%';
    $dat[4]['title'] = 'action';
    $dat[4]['width'] = '5%';
    $dat[5]['title'] = 'delete';
    $dat[5]['width'] = '5%';
    jrCore_page_table_header($dat);

    if (isset($_rt) && is_array($_rt)) {
        foreach ($_rt as $k => $_chan) {

            $dat = array();
            if ($_chan['channel_name'] == 'stable' || $_chan['channel_name'] == 'beta') {
                $dat[1]['title'] = '<big>' . strtoupper($_chan['channel_name']) . '</big>';
                $dat[2]['title'] = 'public';
            }
            else {
                $dat[1]['title'] = '<big>' . $_chan['channel_name'] . '</big>';
                $dat[2]['title'] = 'private';
            }
            $dat[1]['class'] = 'center';
            $dat[2]['class'] = 'center';
            $dat[3]['title'] = (isset($_chan['channel_active']) && $_chan['channel_active'] == '1') ? $pass : $fail;
            $dat[3]['class'] = 'center';
            if ($_chan['channel_active'] == '1') {
                if ($_chan['channel_name'] == 'stable') {
                    $dat[4]['title'] = jrCore_page_button("channel-active-{$k}", 'disable', 'disabled');
                }
                else {
                    $dat[4]['title'] = jrCore_page_button("channel-active-{$k}", 'disable', "jrCore_window_location('{$_conf['jrCore_base_url']}/{$_post['module_url']}/channel_active/id={$_chan['channel_id']}/status=0')");
                }
            }
            else {
                $dat[4]['title'] = jrCore_page_button("channel-active-{$k}", 'enable', "jrCore_window_location('{$_conf['jrCore_base_url']}/{$_post['module_url']}/channel_active/id={$_chan['channel_id']}/status=1')");
            }
            if ($_chan['channel_name'] == 'stable' || $_chan['channel_name'] == 'beta') {
                $dat[5]['title'] = jrCore_page_button("channel-delete-{$k}", 'delete', 'disabled');
            }
            else {
                $dat[5]['title'] = jrCore_page_button("channel-delete-{$k}", 'delete', "jrCore_window_location('{$_conf['jrCore_base_url']}/{$_post['module_url']}/channel_delete_save/id={$_chan['channel_id']}')");
            }
            jrCore_page_table_row($dat);
        }
    }
    else {
        $dat             = array();
        $dat[1]['title'] = '<p>No marketplace channels found</p>';
        $dat[1]['class'] = 'center';
        jrCore_page_table_row($dat);
    }
    jrCore_page_table_footer();

    jrCore_set_form_notice('notice', 'If you have received a private channel invitation, enter the invite code below');
    jrCore_get_form_notice();

    // Form init
    $_tmp = array(
        'submit_value'     => 'add channel',
        'cancel'           => "{$_conf['jrCore_base_url']}/{$_post['module_url']}/admin/tools",
        'form_ajax_submit' => false
    );
    jrCore_form_create($_tmp);

    // Channel System ID
    $_opt = jrMarket_get_active_systems();
    if ($_opt && is_array($_opt)) {
        if (count($_opt) > 1) {
            $_tmp = array(
                'name'     => 'channel_system_id',
                'label'    => 'Channel System',
                'help'     => 'Select the Marketplace System you want to add this channel for',
                'type'     => 'select',
                'options'  => $_opt,
                'validate' => 'number_nz',
                'required' => true
            );
            jrCore_form_field_create($_tmp);
        }
        else {
            $_opt = array_keys($_opt);
            $_tmp = array(
                'name'  => 'channel_system_id',
                'type'  => 'hidden',
                'value' => reset($_opt)
            );
            jrCore_form_field_create($_tmp);
        }
    }

    // Channel Name
    $_tmp = array(
        'name'     => 'channel_code',
        'label'    => 'Channel Invite Code',
        'help'     => 'Enter the Channel Invite Code you received by email to subscribe to the private channel.',
        'type'     => 'text',
        'validate' => 'printable',
        'required' => true
    );
    jrCore_form_field_create($_tmp);
    jrCore_page_display();
}
