<?php
 /**
 * Jamroom Email Support module
 *
 * copyright 2024 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: i
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrMailer_i($_post, $_user, $_conf)
{
    ignore_user_abort(true);
    // _1 = campaign ID
    // _2 = user ID
    if (isset($_post['_1']) && jrCore_checktype($_post['_1'], 'number_nz') && isset($_post['_2']) && jrCore_checktype($_post['_2'], 'number_nz')) {

        // Watch for proxy loading of images
        if (jrMailer_is_real_user_agent()) {
            $ins = true;
            $uid = (int) $_post['_2'];
            if (jrUser_is_logged_in() && $_user['_user_id'] != $uid) {
                // Spoof attempt - do not record
                $ins = false;
            }
            if ($ins) {
                $cid = (int) $_post['_1'];  // campaign ID
                $uip = jrCore_get_ip();     // IP Address
                $agn = isset($_SERVER['HTTP_USER_AGENT']) ? jrCore_db_escape($_SERVER['HTTP_USER_AGENT']) : '';
                $tbl = jrCore_db_table_name('jrMailer', 'track');
                $req = "INSERT INTO {$tbl} (t_cid, t_uid, t_time, t_ip, t_agent)
                        VALUES ({$cid}, {$uid}, UNIX_TIMESTAMP(), '{$uip}', '{$agn}')
                        ON DUPLICATE KEY UPDATE t_lat = '', t_ip = '{$uip}', t_agent = VALUES(t_agent)";
                jrCore_db_query($req);
            }
        }
    }
    // Send response
    $key = 'jrmailer_i_gif';
    if (!$img = jrCore_get_local_cache_key($key)) {
        if ($img = jrCore_file_get_contents(APP_DIR . '/modules/jrMailer/img/1.gif')) {
            jrCore_set_local_cache_key($key, $img, 14400);
        }
        else {
            // Could not load gif - try 204 no content
            header("HTTP/1.0 204 No Content");
            exit();
        }
    }
    header("Content-type: image/gif");
    header('Content-Disposition: inline; filename="link.gif"');
    header('Expires: ' . gmdate('D, d M Y H:i:s \G\M\T', time() + 8640000));
    echo $img;
    exit();
}
